<?php

require_once ac_global_classes("select.php");

function report_list_subscription_select_query(&$so, $listid = 0) {
	$admin = ac_admin_get();
	$uid = 1;
	if ( $admin['id'] != 1 ) {
		$lists = implode("', '", $admin["lists"]);
		$so->push("AND l.id IN ('$lists')");
		$uid = $admin['id'];
	}
	if ( $listid = (int)$listid ) {
		$so->push("AND l.id = '$listid'");
	}
	if ( !isset($so->subqueryconds) ) $so->subqueryconds = '';
	$subqueryconds_udate = str_replace('c.sdate', 'c.udate', $so->subqueryconds);

	$startdate = false;
	$stopdate  = false;

	if (isset($_SESSION["report_list_subscription_datetimefrom"])) {
		$startdate = $_SESSION["report_list_subscription_datetimefrom"];
	}

	if (isset($_SESSION["report_list_subscription_datetimeto"])) {
		$stopdate = $_SESSION["report_list_subscription_datetimeto"];
	}

	if ($startdate) {
		$sstart = "TO_DAYS('{$startdate}') AS a_sstart";
		$ustart = "TO_DAYS('{$startdate}') AS a_ustart";
	} else {
		$sstart = "TO_DAYS((SELECT c.sdate FROM #subscriber_list c WHERE c.id = (SELECT MIN(cc.id) FROM #subscriber_list cc WHERE cc.listid = l.id AND cc.status = 1))) AS a_sstart";
		$ustart = "TO_DAYS((SELECT c.sdate FROM #subscriber_list c WHERE c.id = (SELECT MIN(cc.id) FROM #subscriber_list cc WHERE cc.listid = l.id AND cc.status = 2))) AS a_ustart";
	}

	if ($stopdate) {
		$sstop = "TO_DAYS('{$startdate}') AS a_sstop";
		$ustop = "TO_DAYS('{$startdate}') AS a_ustop";
	} else {
		$sstop = "TO_DAYS((SELECT c.sdate FROM #subscriber_list c WHERE c.id = (SELECT MAX(cc.id) FROM #subscriber_list cc WHERE cc.listid = l.id AND cc.status = 1))) AS a_sstop";
		$ustop = "TO_DAYS((SELECT c.sdate FROM #subscriber_list c WHERE c.id = (SELECT MAX(cc.id) FROM #subscriber_list cc WHERE cc.listid = l.id AND cc.status = 2))) AS a_ustop";
	}

	return $so->query("
		SELECT
			l.id,
			l.name,
			( SELECT COUNT(DISTINCT(c.subscriberid)) FROM #subscriber_list c WHERE c.listid = l.id AND c.status = 1 {$so->subqueryconds} ) AS subscribed,
			( SELECT COUNT(DISTINCT(c.subscriberid)) FROM #subscriber_list c WHERE c.listid = l.id AND c.status = 2 {$subqueryconds_udate} ) AS unsubscribed,
			$sstart,
			$ustart,
			$sstop,
			$ustop
		FROM
			#list l,
			#user_p p
		WHERE
		[...]
		AND
			p.userid = '$uid'
		AND
			p.listid = l.id
	");
}

function report_list_subscription_divide($a, $b) {
	if ($b == 0)
		return 0;
	else
		return floatval($a) / floatval($b);
}

function report_list_subscription_averages(&$ary) {
	foreach ($ary as $k => $v) {
		$ary[$k]["a_avgsub"]   = report_list_subscription_divide($v["subscribed"],   $v["a_sstop"] - $v["a_sstart"]);
		$ary[$k]["a_avgunsub"] = report_list_subscription_divide($v["unsubscribed"], $v["a_ustop"] - $v["a_ustart"]);
	}
}

function report_list_subscription_select_row($id) {
	$id = intval($id);
	$so = new AC_Select;
	$so->push("AND l.id = '$id'");

	return ac_sql_select_row(report_list_subscription_select_query($so));
}

function report_list_subscription_select_array($so = null, $ids = null, $filter = 0) {
	// select object
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	// passed ids to filter to
	if ($ids !== null) {
		if ( !is_array($ids) ) $ids = explode(',', $ids);
		$tmp = array_diff(array_map("intval", $ids), array(0));
		$ids = implode("','", $tmp);
		$so->push("AND l.id IN ('$ids')");
	}

	// any filters used
	$filter = intval($filter);
	if ($filter > 0) {
		$so = select_filter_comment_parse($so, $filter, 'report_list_subscription');
	}

	// fetch the rows
	//dbg(ac_prefix_replace(report_list_subscription_select_query($so)));
	$rows = ac_sql_select_array($q = report_list_subscription_select_query($so));
	report_list_subscription_averages($rows);
	return $rows;
}

function report_list_subscription_select_array_paginator($id, $sort, $offset, $limit, $filter, $listid = 0) {
	$so = new AC_Select;
	$so->subqueryconds = '';

	$filter = intval($filter);
	if ($filter > 0) {
		$so = select_filter_comment_parse($so, $filter, 'report_list_subscription');
	}

	$so->count();
	$total = (int)ac_sql_select_one(report_list_subscription_select_query($so, $listid));

	switch ($sort) {
		default:
		case "01":
			$so->orderby("name"); break;
		case "01D":
			$so->orderby("name DESC"); break;
		case "02":
			$so->orderby("subscribed"); break;
		case "02D":
			$so->orderby("subscribed DESC"); break;
		case "03":
			$so->orderby("unconfirmed"); break;
		case "03D":
			$so->orderby("unconfirmed DESC"); break;
		case "04":
			$so->orderby("unsubscribed"); break;
		case "04D":
			$so->orderby("unsubscribed DESC"); break;
		case "05":
			$so->orderby("bounced"); break;
		case "05D":
			$so->orderby("bounced DESC"); break;
		case "06":
			$so->orderby("campaigns"); break;
		case "06D":
			$so->orderby("campaigns DESC"); break;
		case "07":
			$so->orderby("emails"); break;
		case "07D":
			$so->orderby("emails DESC"); break;
		case "08":
			$so->orderby("epd"); break;
		case "08D":
			$so->orderby("epd DESC"); break;
	}

	if ( (int)$limit == 0 ) $limit = 999999999;
	$limit  = (int)$limit;
	$offset = (int)$offset;
	$so->limit("$offset, $limit");
	$rows = report_list_subscription_select_array($so);

	return array(
		"paginator"   => $id,
		"offset"      => $offset,
		"limit"       => $limit,
		"total"       => $total,
		"cnt"         => count($rows),
		"rows"        => $rows,
	);
}

function report_list_subscription_filter_post() {
	$whitelist = array("l.name", "l.stringid", "l.analytics_source", "l.twitter_user", "l.to_name");

	$ary = array(
		"userid" => $GLOBALS['admin']['id'],
		"sectionid" => "report_list_subscription",
		"conds" => "",
		"=tstamp" => "NOW()",
	);

	if (isset($_POST["qsearch"]) && !isset($_POST["content"])) {
		$_POST["content"] = $_POST["qsearch"];
	}

	if (isset($_POST["content"]) and $_POST["content"] != "") {
		$content = ac_sql_escape($_POST["content"], true);
		$conds = array();

		if (!isset($_POST["section"]) || !is_array($_POST["section"]))
			$_POST["section"] = $whitelist;

		foreach ($_POST["section"] as $sect) {
			if (!in_array($sect, $whitelist))
				continue;
			$conds[] = "$sect LIKE '%$content%'";
		}

		$conds = implode(" OR ", $conds);
		$ary["conds"] = "AND ($conds) ";
	}
	/*
	if ( isset($_POST['listid']) ) {
		if ( defined('ACPUBLIC') ) {
			$_SESSION['nlp'] = $_POST['listid'];
		} else {
			$_SESSION['nla'] = $_POST['listid'];
		}
	}
	*/
	$nl = null;
	if ( isset($_SESSION['nlp']) and defined('ACPUBLIC') ) {
		$nl = $_SESSION['nlp'];
	} elseif ( isset($_SESSION['nla']) ) {
		$nl = $_SESSION['nla'];
	}
	if ( $nl ) {
		if ( is_array($nl) ) {
			if ( count($nl) > 0 ) {
				$ids = implode("', '", array_map('intval', $nl));
				$ary['conds'] .= "AND ( SELECT COUNT(*) FROM #list_group l WHERE l.listid IN ('$ids') AND l.groupid = l.id ) > 0 ";
				//$ary['conds'] .= "AND l.listid IN ('$ids') ";
			} else {
				if ( defined('ACPUBLIC') ) {
					unset($_SESSION['nlp']);
				} else {
					unset($_SESSION['nla']);
				}
			}
		} else {
			$listid = (int)$nl;
			if ( $listid > 0 ) {
				$ary['conds'] .= "AND ( SELECT COUNT(*) FROM #list_group l WHERE l.listid = '$listid' AND l.groupid = l.id ) > 0 ";
				//$ary['conds'] .= "AND l.listid = '$listid' ";
			} else {
				if ( defined('ACPUBLIC') ) {
					unset($_SESSION['nlp']);
				} else {
					unset($_SESSION['nla']);
				}
			}
		}
	}

	if ( isset($_POST['datetimefilter'])  ) {
		$_SESSION['report_list_subscription_datetime'] = $_POST['datetimefilter'];
	}
	if ( isset($_POST['from'])  ) {
		$_SESSION['report_list_subscription_datetimefrom'] = $_POST['from'];
	}
	if ( isset($_POST['to'])  ) {
		$_SESSION['report_list_subscription_datetimeto'] = $_POST['to'];
	}
	if ( isset($_SESSION['report_list_subscription_datetime']) and $_SESSION['report_list_subscription_datetime'] != 'all' ) {
		$comment = '';
		$from = '';
		$to = '';
		switch ( $_SESSION['report_list_subscription_datetime'] ) {
			case 'today':
				$comment = "AND DATE(c.sdate) = CURDATE()";
				break;
			case 'week':
				$from = date('Y-m-d', strtotime('last Monday'));
				$comment = "AND c.sdate >= '$from' AND c.sdate < DATE(NOW() + INTERVAL 1 DAY)";
				break;
			case 'month':
				$from = substr(AC_CURRENTDATE, 0, -2) . '01';
				$comment = "AND c.sdate >= '$from' AND c.sdate < DATE(NOW() + INTERVAL 1 DAY)";
				break;
			case 'year':
				$from = substr(AC_CURRENTDATE, 0, -5) . '01-01';
				$comment = "AND c.sdate >= '$from' AND c.sdate < DATE(NOW() + INTERVAL 1 DAY)";
				break;
			case 'range':
				if ( isset($_SESSION['report_list_subscription_datetimefrom']) and isset($_SESSION['report_list_subscription_datetimeto']) ) {
					// sanitize from
					$from = @strtotime($_SESSION['report_list_subscription_datetimefrom']);
					if ( $from == -1 ) $from = false;
					if ( $from ) $from = date('Y-m-d', $from);
					// sanitize to
					$to = @strtotime($_SESSION['report_list_subscription_datetimeto']);
					if ( $to == -1 ) $to = false;
					if ( $to ) $to = date('Y-m-d', $to);
					// make condition
					if ( $from and $to ) {
						$comment = "AND c.sdate >= '$from' AND c.sdate < ('$to' + INTERVAL 1 DAY)";
					} else { // reset to a 30 day interval?
						//$comment = "AND c.sdate >= DATE(CURDATE() - INTERVAL 30 DAY) AND c.sdate < (NOW() + INTERVAL 1 DAY)";
					}
				}
				break;
		}
		if ( $comment != '' ) {
			$ary['conds'] .= " /* datetime: " . base64_encode($comment) . " */ ";
			//$_SESSION['report_list_subscription_datetime'] = $_POST['datetimefilter'];
			if ( $from ) $_SESSION['report_list_subscription_datetimefrom'] = $from;
			if ( $to   ) $_SESSION['report_list_subscription_datetimeto'] = $to;
		}
	}

	if ( $ary['conds'] == '' ) return array('filterid' => 0);

	$conds_esc = ac_sql_escape($ary["conds"]);
	$filterid = ac_sql_select_one("
		SELECT
			id
		FROM
			#section_filter
		WHERE
			userid = '$ary[userid]'
		AND
			sectionid = 'report_list_subscription'
		AND
			conds = '$conds_esc'
	");

	if (intval($filterid) > 0)
		return array("filterid" => $filterid);
	ac_sql_insert("#section_filter", $ary);
	return array("filterid" => ac_sql_insert_id());
}

?>
