<?php

require_once(ac_global_functions('import.php'));
require_once(ac_admin('functions/subscriber.php'));
require_once ac_global_functions("log.php");

// these are using sync's ihooks

require_once(ac_global_functions('sync.php'));

ac_ihook_define('ac_import_tplvars',  'ihook_ac_sync_tplvars');
ac_ihook_define('ac_import_header_template',  'ihook_ac_import_header_template');
ac_ihook_define('ac_import_destinations_template',  'ihook_ac_sync_destinations_template');
ac_ihook_define('ac_import_relations',  'ihook_ac_sync_relations');
ac_ihook_define('ac_import_fields',  'ihook_ac_sync_fields');
ac_ihook_define('ac_import_custom_fields',  'ihook_ac_sync_custom_fields');
ac_ihook_define('ac_import_options',  'ihook_ac_sync_options');
ac_ihook_define('ac_import_valid_check',  'ihook_ac_import_valid_check');
ac_ihook_define('ac_import_valid_row',  'ihook_ac_import_valid_row');

ac_ihook_define('ac_import_row',  'ihook_ac_import_row');
ac_ihook_define('ac_import_delete_all',  'ihook_ac_sync_delete_all');

ac_ihook_define('ac_import_row_report',  'ihook_ac_sync_row_report');

function ihook_ac_import_row($cfg, $row, $test = false) {
	$cfg["isimported"] = 1;
	return ihook_ac_sync_row($cfg, $row, $test);
}

function import_relid_change($relids, $type = 'subscribe') {
	$offer = (int)( $type == 'unsubscribe' or $type == 'subscribe' );
	if ( $type != 'unsubscribe' ) $type = 'subscribe';
	if ( !$relids ) $relids = null;
	$lists = list_select_array(null, $relids, 'optinout');
	$so = new AC_Select();
	$so->push("AND `responder_type` = '$type'");
	//$so->push("AND `status` = 1");
	$r = array(
		'responders' => responder_select_bylist($so, $relids),
		'offeroptin' => 0,
		'offeroptout' => 0,
		'offerresponders' => $offer,
		'offersentresponders' => 0,
	);
	foreach ( $lists as $v ) {
		if ( $v['optin_confirm'] ) $r['offeroptin'] = 1;
		if ( $v['optout_confirm'] ) $r['offeroptout'] = 1;
	}
	$r['offersentresponders'] = count($r['responders']);
/*
	foreach ( $r['responders'] as $v ) {
		if ( $v['responder_offset'] > 0 ) $r['offerResponders'] = 1;
	}
*/
	return $r;
}


function ihook_ac_import_header_template() {
	if ( (int)ac_sql_select_one('=COUNT(*)', '#subscriber_import') > 100000 ) {
		ac_sql_query("TRUNCATE TABLE #subscriber_import");
	} else {
		ac_sql_delete('#subscriber_import', "`tstamp` < SUBDATE(NOW(), INTERVAL 1 DAY)");
	}
	return 'subscriber_import.header.inc.htm';
}

function ihook_ac_import_valid_check($r) {
	return isset($GLOBALS['_hosted_account']) || withinlimits('subscriber', limit_count($GLOBALS['admin'], 'subscriber') + $r['rows']);
}

function ihook_ac_import_valid_row($row) {
	return subscriber_add_valid($row);
}

/* NEW IMPORTER */

function subscriber_import_fileinfo($fp, $delimiter) {
	$rval = array();

	if (feof($fp))
		return $rval;

	$rval["lines"] = 0;
	$five          = array();

	while (!feof($fp)) {
		if (count($five) < 5)
			$five[] = trim(ac_file_readline($fp));
		else
			ac_file_readline($fp);

		$rval["lines"]++;
	}

	$rval["delimiter_file"] = "comma";
	if (count($five) > 0)
		$rval["delimiter_file"] = ac_import_delimiter_guess($five[0]);

	# Now do validation, check for fields.
	$csv = ac_import_csv2array(implode("\n", $five), $rval["delimiter_file"]);
	$rval["fields"] = ac_import_columns($csv);
	$rval["valid"] = true;

	if (count($csv) > 0) {
		$first = count($csv[0]);
		foreach ($csv as $csvrow) {
			if (count($csvrow) != $first)
				$rval["valid"] = false;
		}
	}

	rewind($fp);
	return $rval;
}

function responder_select_bylist($so = null, $ids = null) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	if ($ids !== null) {
		$tmp = array_map("intval", explode(",", $ids));
		$ids = implode("', '", $tmp);
		$so->push("AND l.listid IN ('$ids')");
	}
	$so->push("AND c.type = 'responder'");
	$so->push("AND c.status IN (1, 5)");
	return ac_sql_select_array(campaign_select_query($so), array('cdate', 'sdate', 'ldate'));
}

function subscriber_import_external($config, $post) {
	$r = array(
		'succeeded' => false,
		'message' => _a('Unknown Error'),
		'data' => '',
	);
	if ( !$post['external'] ) {
		$r['message'] = _a('External Source not provided.');
		return $r;
	}
	if ( $post['external'] == 'hd' ) {
		if ( !function_exists('curl_init') ) {
			$r['message'] = _a('PHP cURL extension required.');
			return $r;
		}
		// check input first
		if ( !isset($post['hd_url']) or !ac_str_is_url($post['hd_url']) ) {
			$r['message'] = _a('Help Desk URL is not valid.');
			return $r;
		}
		if ( !isset($post['hd_user']) or !trim($post['hd_user']) or !isset($post['hd_pass']) ) {
			$r['message'] = _a('Help Desk login credentials must be provided.');
			return $r;
		}
		// connect and fetch here
		$params = array(
			'api_user'     => $post['hd_user'],
			'api_pass'     => $post['hd_pass'],
			'api_action'   => 'user_list_group',
			'api_output'   => 'serialize',
			'ids'          => '2',
		);
		$query = "";
		foreach( $params as $key => $value ) $query .= $key . '=' . urlencode($value) . '&';
		$query = rtrim($query, '& ');
		$url = rtrim($post['hd_url'], '/ ');
		$api = $url . '/admin/api.php?' . $query;
		$request = curl_init($api); // initiate curl object
		curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response
		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)
		//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS
		$response = (string)curl_exec($request); // execute curl fetch and store results in $response
		curl_close($request); // close curl object
		if ( !$response ) {
			$r['message'] = _a('Nothing was returned. Do you have a connection to Help Desk server?');
			return $r;
		}
		$result = @unserialize($response);
		if ( !is_array($result) or !isset($result['result_code']) ) {
			$r['message'] = _a('Improper response received from Help Desk. Please try again later.');
			return $r;
		}
		if ( !$result['result_code'] ) {
			$r['message'] = $result['result_message'];
			return $r;
		}
		if ( !$result['rows'] ) {
			$r['message'] = _a('No records were found.');
			return $r;
		}
		$firstrow = current($result['rows']);
		$header = array_keys($firstrow);
		$r['data'] = ac_array_csv($result['rows'], $header, $output = array());
	} elseif ( $post['external'] == 'capsule' ) {
		if ( !function_exists('curl_init') ) {
			$r['message'] = _a('PHP cURL extension required.');
			return $r;
		}
		if ( !function_exists('simplexml_load_string') ) {
			$r['message'] = _a('PHP SimpleXML extension required.');
			return $r;
		}
		if ( !isset($post['capsule_app']) or !trim($post['capsule_app']) ) {
			$r['message'] = _a('Capsule application must be provided.');
			return $r;
		}
		if ( !isset($post['capsule_token']) or !trim($post['capsule_token']) ) {
			$r['message'] = _a('Capsule token must be provided.');
			return $r;
		}
		$request = curl_init('https://' . $post['capsule_app'] . '.capsulecrm.com/api/party');
		curl_setopt($request, CURLOPT_HEADER, 0);
		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($request, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($request, CURLOPT_USERAGENT, 'ActiveCampaign Email Marketing software');
		curl_setopt($request, CURLOPT_USERPWD, $post['capsule_token'] . ':x');
		$response = curl_exec($request);
		curl_close($request);
		// any errors returned?
		if ( preg_match('/Error report/', $response) ) {
			// grab first <h1> from the result string (its HTML returned)
			// try to grab the error from the HTML return string
			$h1 = preg_match('|<h1>[^</]*|', $response, $h1_matches);
			if ($h1_matches && $h1_matches[0] && $h1_matches[0] != '') {
				$error = substr($h1_matches[0], 4);
			}
			$r['message'] = $error;
			return $r;
		}
		$object = simplexml_load_string($response);
		$people = array();
		//dbg($object);
		foreach ($object -> person as $person) {
			$person = get_object_vars($person);
			$email = '';
			if ( isset($person['contacts'] -> email) ) {
				$email = get_object_vars($person['contacts'] -> email);
				$email = $email['emailAddress'];
			}
			$person_first_name = ( isset($person['firstName']) ) ? $person['firstName'] : '';
			$person_last_name = ( isset($person['lastName']) ) ? $person['lastName'] : '';
			$person = array(
				'firstName' => $person_first_name,
				'lastName' => $person_last_name,
				'fullName' => $person_first_name . ' ' . $person_last_name,
				'email' => $email,
			);
			$people[] = $person;
		}
		//dbg($people);
		$firstrow = current($people);
		$header = array_keys($firstrow);
		$r['data'] = ac_array_csv($people, $header, $output = array());
	} elseif ( $post['external'] == 'microsoftcrm' ) {
		if ( !isset($post['microsoftcrm_username']) or !trim($post['microsoftcrm_username']) ) {
			$r['message'] = _a('Microsoft CRM username must be provided.');
			return $r;
		}
		if ( !isset($post['microsoftcrm_password']) or !trim($post['microsoftcrm_password']) ) {
			$r['message'] = _a('Microsoft CRM password must be provided.');
			return $r;
		}
		if ( !isset($post['microsoftcrm_organization']) or !trim($post['microsoftcrm_organization']) ) {
			$r['message'] = _a('Microsoft CRM organization must be provided.');
			return $r;
		}
		if ( !isset($post['microsoftcrm_domain']) or !trim($post['microsoftcrm_domain']) ) {
			$r['message'] = _a('Microsoft CRM domain must be provided.');
			return $r;
		}
		require_once( ac_global_classes('microsoft.crm.php') );
		$service = new MSCrmIFD();
		$service->usr = $post['microsoftcrm_username'];
		$service->pwd = $post['microsoftcrm_password'];
		$service->domain = $post['microsoftcrm_domain'];
		$service->org = $post['microsoftcrm_organization'];
		//$service->crmHost = 'crm.example.ex:5555';
		$service->crmHost = $post['microsoftcrm_domain'];
		$service->getAccess();
	} elseif ( $post['external'] == 'zohocrm' ) {
		if ( !function_exists('curl_init') ) {
			$r['message'] = _a('PHP cURL extension required.');
			return $r;
		}
		if ( !function_exists('simplexml_load_string') ) {
			$r['message'] = _a('PHP SimpleXML extension required.');
			return $r;
		}
		if ( !isset($post['zohocrm_apikey']) or !trim($post['zohocrm_apikey']) ) {
			$r['message'] = _a('Zoho CRM API key must be provided.');
			return $r;
		}
		if ( !isset($post['zohocrm_username']) or !trim($post['zohocrm_username']) ) {
			$r['message'] = _a('Zoho CRM username must be provided.');
			return $r;
		}
		if ( !isset($post['zohocrm_password']) or !trim($post['zohocrm_password']) ) {
			$r['message'] = _a('Zoho CRM password must be provided.');
			return $r;
		}
		$request_login = curl_init('https://accounts.zoho.com/login?servicename=ZohoCRM&FROM_AGENT=true&LOGIN_ID=' . $post['zohocrm_username'] . '&PASSWORD=' . $post['zohocrm_password']);
		curl_setopt($request_login, CURLOPT_HEADER, 0);
		curl_setopt($request_login, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($request_login, CURLOPT_SSL_VERIFYPEER, FALSE);
		$response_login = curl_exec($request_login);
		curl_close($request_login);
		$response_login_lines = explode("\n", $response_login);
		foreach ($response_login_lines as $line) {
			if ( preg_match("/RESULT=/", $line) ) {
				$response_login_result = substr($line, 7);
			}
			if ( preg_match("/TICKET=/", $line) ) {
				$response_login_ticket = substr($line, 7);
			}
		}
		if ($response_login_result == "TRUE") {
			$request_data = curl_init("http://crm.zoho.com/crm/private/xml/Contacts/getRecords?apikey=" . $post["zohocrm_apikey"] . "&ticket=" . $response_login_ticket . "&selectColumns=Contacts(Email)&newFormat=2");
			curl_setopt($request_data, CURLOPT_HEADER, 0);
			curl_setopt($request_data, CURLOPT_RETURNTRANSFER, 1);
			$response_data = curl_exec($request_data);
			curl_close($request_data);
			$object = simplexml_load_string($response_data, 'SimpleXMLElement', LIBXML_NOCDATA);
			$people = array();
			foreach ($object -> result -> Contacts -> row as $contact) {
				$contact = get_object_vars($contact);
				$contact_email = $contact['FL'][1];
				if ($contact_email != 'null') {
					$people[] = array("email" => $contact_email);
				}
			}
			if (!$people) {
				$r['message'] = _a('No records were found.');
				return $r;
			}
			//dbg($people);
			$firstrow = current($people);
			$header = array_keys($firstrow);
			$r['data'] = ac_array_csv($people, $header, $output = array());
		}
		else {
			$r['message'] = _a("Login failed. Please verify your username and password.");
			return $r;
		}

	} elseif ( $post['external'] == 'sugarcrm' ) {
		if ( (int)PHP_VERSION < 5 ) {
			$r['message'] = _a("This external source requires PHP 5");
			return $r;
		}
		if ( !class_exists('SoapClient') ) {
			$r['message'] = _a("This external source requires PHP SOAP extension");
			return $r;
		}
		if ( !isset($post['sugarcrm_url']) or !trim($post['sugarcrm_url']) ) {
			$r['message'] = _a('SugarCRM URL must be provided.');
			return $r;
		}
		if ( !isset($post['sugarcrm_username']) or !trim($post['sugarcrm_username']) ) {
			$r['message'] = _a('SugarCRM username must be provided.');
			return $r;
		}
		if ( !isset($post['sugarcrm_password']) or !trim($post['sugarcrm_password']) ) {
			$r['message'] = _a('SugarCRM password must be provided.');
			return $r;
		}
		require_once(ac_global_functions('sugarcrm.php'));
		$connection = ac_sugarcrm_connect($post);
		if ($connection['error']) {
			$r['message'] = $connection['error'];
			return $r;
		}
		$params_contacts = array('id', 'first_name', 'last_name', 'email1', 'account_name', 'account_id', 'phone_work');
		$contacts = $connection['client']->get_entry_list($connection['login']->id, 'Contacts', '', '', 0, $params_contacts, 5000, false);
		$people = array();
		foreach ($contacts->entry_list as $entry) {
			$person = array();
			foreach ($entry->name_value_list as $data) {
				$property = get_object_vars($data);
				$person[ $property['name'] ] = $property['value'];
			}
			$people[] = $person;
		}
		if (!$people) {
			$r['message'] = _a('No records were found.');
			return $r;
		}
		//dbg($people);
		$firstrow = current($people);
		$header = array_keys($firstrow);
		$r['data'] = ac_array_csv($people, $header, $output = array());
	} elseif ( $post['external'] == 'salesforce' ) {
		if ( (int)PHP_VERSION < 5 ) {
			$r['message'] = _a("This external source requires PHP 5");
			return $r;
		}
		if ( !class_exists('SoapClient') ) {
			$r['message'] = _a("This external source requires PHP SOAP extension");
			return $r;
		}
		require_once(ac_global_functions('salesforce.php'));
		$connection = ac_salesforce_connect($post);
		if ( is_array($connection) ) {
			$r['message'] = $connection['message'];
			return $r;
		}
		$query = "SELECT Id, FirstName, LastName, Email from Contact";
		$response = $connection->query($query);
		$queryResult = new QueryResult($response);
		$people = array();
		foreach ($queryResult->records as $record) {
			$person = get_object_vars($record);
			$person = array(
				"FirstName" => $person['fields'] -> FirstName,
				"LastName" => $person['fields'] -> LastName,
				"Email" => $person['fields'] -> Email,
			);
			$people[] = $person;
		}
		//dbg($people);
		if (!$people) {
			$r['message'] = _a('No records were found.');
			return $r;
		}
		$firstrow = current($people);
		$header = array_keys($firstrow);
		$r['data'] = ac_array_csv($people, $header, $output = array());
	} elseif ( $post['external'] == 'freshbooks' ) {
		if ( !function_exists('curl_init') ) {
			$r['message'] = _a('PHP cURL extension required.');
			return $r;
		}
		if ( !isset($post['freshbooks_account']) or !trim($post['freshbooks_account']) or !isset($post['freshbooks_apikey']) ) {
			$r['message'] = _a('Freshbook account details must be provided.');
			return $r;
		}
		if ( !function_exists('simplexml_load_string') ) {
			$r['message'] = _a('PHP SimpleXML extension required.');
			return $r;
		}
		$request = curl_init('https://' . $post['freshbooks_account'] . '.freshbooks.com/api/2.1/xml-in');
		$post_xml = '<request method="client.list"></request>';
		curl_setopt($request, CURLOPT_HEADER, 0);
		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($request, CURLOPT_POSTFIELDS, $post_xml);
		curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($request, CURLOPT_USERAGENT, time());
		curl_setopt($request, CURLOPT_USERPWD, $post['freshbooks_apikey'] . ':X');
		$response = curl_exec($request);
		curl_close($request);
		if ( !$response ) {
			$r['message'] = _a('Nothing was returned. Please verify your connection details with FreshBooks.');
			return $r;
		}
		$object = simplexml_load_string($response);
		$people = array();

		if (isset($object->clients) && isset($object->clients->client)) {
			foreach ($object -> clients -> client as $client) {
				$person = get_object_vars($client);
				$person = array(
					"client_id" => $person["client_id"],
					"username" => $person["username"],
					"first_name" => $person["first_name"],
					"last_name" => $person["last_name"],
					"email" => $person["email"],
				);
				$people[] = $person;
			}
		}

		//dbg($people);
		if (!$people) {
			$r['message'] = _a('No records were found.');
			return $r;
		}
		$firstrow = current($people);
		$header = array_keys($firstrow);
		$r['data'] = ac_array_csv($people, $header, $output = array());
	} elseif ( $post['external'] == 'google_contacts' ) {
		if ( (int)PHP_VERSION < 5 ) {
			$r['message'] = _a("This external source requires PHP 5");
			return $r;
		}
		if ( !isset($post['google_contacts_user']) or !trim($post['google_contacts_user']) or !isset($post['google_contacts_pass']) ) {
			$r['message'] = _a('Google Account login credentials must be provided.');
			return $r;
		}
		$user = $post['google_contacts_user'];
		$pass = $post['google_contacts_pass'];
		require_once( ac_global('scripts/import_google_contacts.php') );
		if (!$r['succeeded']) return $r;
	} elseif ( $post['external'] == 'hr' ) {
		// check input first
		if ( !isset($post['hr_url']) or !ac_str_is_url($post['hr_url']) ) {
			$r['message'] = _a('Highrise URL is not valid.');
			return $r;
		}
		if ( !isset($post['hr_api']) or !trim($post['hr_api']) ) {
			$r['message'] = _a('Highrise API token must be provided.');
			return $r;
		}
		// connect and fetch here
		if ( preg_match('/^http:\/\//i', $post['hr_url']) ) {
			$post['hr_url'] = preg_replace('/^http:\/\//i', 'https://', $post['hr_url']);
		}

		if ( !class_exists('SimpleXMLElement') ) return;

		$escurl = ac_sql_escape($post['hr_url']);

		// typical REST request
		require(ac_global_classes('Highrise.class.php'));
		$highrise = new Highrise($post['hr_url'], $post['hr_api'], 'x', 'xml');
		$response = $highrise->getPeople();

		if ( $response['status'] == '401 Unauthorized' ) {
			return loginForm();
		} elseif ( $response['status'] == '403 Forbidden' ) {
			return loginForm();
		} elseif ( $response['status'] == '404 Not Found' ) {
			return loginForm();
		} elseif ( !ac_str_instr('<people', $response['body']) ) {
			return loginForm();
		}
		$highrise->setFormat('simplexml');

		$response = $highrise->getPeople();
		$people = array();
		foreach ( $response['body']->person as $v ) {
			#$people[] = get_object_vars($v);
			$tmp  = get_object_vars($v);
			$rval = array();

			$rval["first-name"]    = $tmp["first-name"];
			$rval["last-name"]     = $tmp["last-name"];
			$rval["created-at"]    = $tmp["created-at"];
			$rval["background"]    = $tmp["background"];
			$rval["email-address"] = "";

			if (isset($tmp["contact-data"]->{"email-addresses"})) {
				$addrs = $tmp["contact-data"]->{"email-addresses"};

				if (isset($addrs->{"email-address"})) {
					if (is_array($addrs->{"email-address"})) {
						$rval["email-address"] = strval($addrs->{"email-address"}[0]->address);
					} else {
						$rval["email-address"] = strval($addrs->{"email-address"}->address);
					}
				}
			}

			$people[] = $rval;
		}
//dbg($people);
		if ( !$people ) {
			$r['message'] = _a('No records were found.');
			return $r;
		}
		$firstrow = current($people);
		$header = array_keys($firstrow);
		$r['data'] = ac_array_csv($people, $header, $output = array());
	} else {
		$r['message'] = _a('External Source not found.');
		return $r;
	}

	$r['succeeded'] = true;
	$r['message'] = _a('External Source successfully fetched.');

	return $r;
}

// detects various server requirements and returns the supported external connectors
function subscriber_import_external_sources($justcheck = false) {
	$admin = ac_admin_get();
	// start out supporting them all
	$r = array(
		"hd" => array( "supported" => 1, "image" => "ac-help.gif" ),
		"capsule" => array( "supported" => 1, "image" => "capsule.jpg" ),
		"freshbooks" => array( "supported" => 1, "image" => "freshbooks.gif" ),
		"google_contacts" => array( "supported" => 1, "image" => "google.gif" ),
		"hr" => array( "supported" => 1, "image" => "highrise.gif" ),
		"salesforce" => array( "supported" => 1, "image" => "salesforce.gif" ),
		"sugarcrm" => array( "supported" => 1, "image" => "sugar.gif" ),
		"zohocrm" => array( "supported" => 1, "image" => "zohocrm.jpg" ),
	);
	// this array is just for individual server requirements
	// this way if a user wants to know which things they are missing, amongst ALL external source requirements
	$server = array(
		"php5" => array( "supported" => 1, "name" => "PHP 5" ),
		"curl" => array( "supported" => 1, "name" => "cURL" ),
		"simplexml" => array( "supported" => 1, "name" => "SimpleXML" ),
		"soap" => array( "supported" => 1, "name" => "SOAP extension" ),
		"brand_links" => array( "supported" => 1, "name" => "Product links (on <a href='main.php?action=design'>Design Settings page</a> - 'Hide product links' checkbox)" ),
	);
	// check for requirements
	if ( !function_exists('curl_init') ) {
		$server["curl"]["supported"] = $r["hd"]["supported"] = $r["capsule"]["supported"] = $r["freshbooks"]["supported"] = $r["zohocrm"]["supported"] = 0;
	}
	if ( (int)PHP_VERSION < 5 ) {
		$server["php5"]["supported"] = $r["google_contacts"]["supported"] = $r["salesforce"]["supported"] = $r["sugarcrm"]["supported"] = 0;
	}
	if ( !function_exists('simplexml_load_string') ) {
		$server["simplexml"]["supported"] = $r["capsule"]["supported"] = $r["freshbooks"]["supported"] = $r["hr"]["supported"] = $r["zohocrm"]["supported"] = 0;
	}
	if ( !class_exists('SoapClient') ) {
		$server["soap"]["supported"] = $r["salesforce"]["supported"] = $r["sugarcrm"]["supported"] = 0;
	}
	if ( !$admin["brand_links"] ) {
		$server["brand_links"]["supported"] = $r["hd"]["supported"] = 0;
	}
	if ($justcheck) {
		return $server;
	}
	else {
		return $r;
	}
}

function subscriber_import_run($post, $test = false, $offset = 0, $prepareOnly = false) {
	ac_import_log_init($post);

	if ( isset($post['process_id']) ) {
		ac_process_update($post['process_id'], false);
		ac_import_log_store("\nPicking up Import Job (process #$post[process_id]) at $offset\n");
	} else {
		$date = date('Y-m-d H:i:s');
		ac_import_log_store("\nStarting Import Job at $date\n");
	}

	// set output to true
	if ( !defined('AC_IMPORT_PRINT') ) define('AC_IMPORT_PRINT', 1);
	// print javascript
	$charset = _i18n("utf-8");
	$prehtml = "<meta http-equiv='Content-Type' content='text/html; charset=$charset' />\n";
	$prehtml .= '
		<script>
			function ac_dom_toggle_display(id, val) {
				document.getElementById(id).style.display = ( document.getElementById(id).style.display == val ? "none" : val );
			}
		</script>
		<style>
		div.ac_help {
			z-index: 999;
			/*display: none;*/
			position:absolute;
			border: 1px solid #B4CDE6;
			padding: 10px;
			width:200px;
			margin-top:6px;
			font-size:10px;
			background:#F0F6FB;
			color:#333333;
		}
		.ac_mapped_column {
			background-color: #ccc;
		}
		</style>
		<link href="css/default.css" rel="stylesheet" type="text/css" />

	';
	ac_import_log_comment($prehtml);
	if ( !( defined('AC_IMPORT_PRINT') and AC_IMPORT_PRINT ) ) ac_flush($prehtml);
	if ( $test ) {
		//ac_import_log_comment(_a('Testing Import'));
	} else {
		//ac_import_log_comment(_a('Starting Import'));
	}

	$r = subscriber_import_src($post, true);
	// if didn't even connect, return
	if ( !$r['succeeded'] ) return $r;

	if (isset($_POST["import_file"])) {
		$post["import_file"] = $_POST["import_file"];
		//$post["type"]        = $_POST["type"];
	}

	// default values
	$r['succeeded'] = false;
	$r['failed'] = 0;
	$r['found'] = $total = $r['lines'];
	$r['imported'] = 0;
	$r['failedrows'] = array();
	$r['importedrows'] = array();

	$useProcesses = function_exists('ac_process_create');
	// this process id
	if ( !isset($post['process_id']) ) {
		if ( $useProcesses ) {
			// comming from form submission, has action param here
			if (isset($r['delimiter_file']))
				$post['delimiter_file'] = $r['delimiter_file'];
			$post['process_id'] = ac_process_create(ac_http_param('action'), $r['found'], $post, false, '0000-00-00 00:00:00');
			ac_process_setdata($post['process_id'], $post);
			/*
			if ( !$test and $prepareOnly ) {
				ac_process_spawn(array('id' => $post['process_id'], 'stall' => 5 * 60));
			}
			*/
		} else {
			// old style - KB3
			$post['process_id'] = rand('100000', '900000');// setting a random process id
		}
	}
	$r['process_id'] = $post['process_id'];

	if ( $useProcesses ) {
		// autoupdate
		//$admin = ac_admin_get();
		//$secondInterval = ( isset($admin['autoupdate']) ? $admin['autoupdate'] : 60 );
		$secondInterval = 3;

		$callback = ( !$test and $prepareOnly ) ? "parent.import_progressbar_callback" : "null";
		ac_import_log_comment(
			'
				<script>//alert(\'process: ' . $r['process_id'] . '\');
					if (parent && parent.ac_progressbar_register && parent.document.getElementById("progressBar")){
						parent.ac_progressbar_register("progressBar", "' . $r['process_id'] . '", 0, ' . $secondInterval . ', true, ' . $callback . ');
						parent.processID = "' . $r['process_id'] . '";
						if ( parent.document.getElementById("report_count") ) {
							parent.document.getElementById("report_count").innerHTML = "' . $total . '";
						}
					}
				</script>
			'
		);
	}

	if ( !$test and $prepareOnly ) {
		if ( $useProcesses ) {
			ac_process_spawn(array('id' => $post['process_id'], 'stall' => 5 * 60));
		}
		$r['message'] = _a("The process has been initiated.");
		$r['succeeded'] = true;
		return $r;
	}

	// options
	$post['delete_all'] = false;

	if ( !isset($post['column']) ) {
		$r['message'] = _a('Fields not mapped properly. Aborting...');
		return $r;
	}
	$post['fieldslist'] = ac_import_mapping_get($post['column']);

	// 2do: check against required fields again

	if ( isset($GLOBALS['_ac_sync_lists']) ) unset($GLOBALS['_ac_sync_lists']);

	ac_import_log_comment(sprintf(_a('Found %d results.  Starting import now...'), $r['found']));

	// if we are starting it
	if ( !$test and !$offset ) {
		// turn off indexes
		if ( $post['destination'] == 3 ) {
			ac_sql_tablekeys("#exclusion", false);
			ac_sql_tablekeys("#exclusion_list", false);
		} else {
			ac_sql_tablekeys("#subscriber", false);
			ac_sql_tablekeys("#subscriber_list", false);
		}
	}

	switch ($r["delimiter_file"]) {
		default:
		case "comma":
			$delim = ",";
			break;
		case "semicolon":
			$delim = ";";
			break;
		case "tab":
			$delim = "\t";
			break;
	}

	$i = 0;
	while ($i < $r["lines"]) {
		$i++;
		$line = ac_file_readline($r["fp"]);
		$line = str_replace(chr(0), "", $line);
		$tmp  = array();
		$off  = 0;
		ac_array_parsecsv($tmp, $off, $line, $delim, true);

 		if (count($tmp) == 0) {
 			# We still want to increment the completed/percentage fields.
 			if ($useProcesses)
 				ac_process_update($post['process_id']);

 			continue;
 		}

		$row = $tmp[0];

		if ( $i > $offset ) {
			$rs = ihook_ac_import_row($post, $row, $test);
			if ( $useProcesses ) ac_process_update($post['process_id']);
			if ( $rs['succeeded'] ) {
				$r['importedrows'][] = $row;
			} else {
				$r['failedrows'][] = $row;
			}
			$r['imported'] += $rs['succeeded'];
			ac_import_log_row($post, ac_utf_deepconv("UTF-8", _i18n("utf-8"), $row), $rs);
		}
	}

	fclose($r["fp"]);

	// cleanup if not a test
	if ( !$test ) {
		// turn off indexes
		if ( $post['destination'] == 3 ) {
			ac_sql_tablekeys("#exclusion", true);
			ac_sql_tablekeys("#exclusion_list", true);
		} else {
			ac_sql_tablekeys("#subscriber", true);
			ac_sql_tablekeys("#subscriber_list", true);
		}
		// delete all check
		if ( $post['delete_all'] ) ac_ihook('ac_import_delete_all', $post);
		//ac_ihook('ac_import_cleanup', $post, $r);
	}

	$r['failed'] = $r['found'] - $r['imported'] - $offset;
	// done
	$r['succeeded'] = ( $r['found'] == $r['imported'] );
	$r['message'] = sprintf(_a('Import Completed. %d items found, %d items imported.'), $r['found'], $r['imported']);
	$jsfunc = ( $r['succeeded'] ? 'ac_result_show' : 'ac_error_show' );
	if ( $r['found'] > 0 ) ac_import_log_comment('</table>');


	ac_import_log_comment(
		'
			<script>
				if (parent && parent.ac_ui_api_callback)
					parent.ac_ui_api_callback();
				if (parent && parent.' . $jsfunc . ')
					parent.' . $jsfunc . '("' . htmlentities($r['message']) . '");
			</script>
		'
	);

	if ( $useProcesses ) {
		ac_import_log_comment(
			'
				<script>
					if (parent && parent.ac_progressbar_register && parent.document.getElementById("progressBar")) {
						parent.ac_progressbar_set("progressBar", 100);
						parent.ac_progressbar_unregister("progressBar");
					}
				</script>
			'
		);
	}


	if ( !$test ) {
		// fix all newly added custom fields
		if ( isset($post['newfields']) and count($post['newfields']) ) {
			foreach ( $post['newfields'] as $field ) {
				// add remaining custom fields stuff (such as multiple options for radios/dropdowns)
				$values = ac_sql_select_list("
					SELECT
						CONCAT(val, '||', val)
					FROM
						#list_field_value
					WHERE
						fieldid = '$field[fieldid]'
					GROUP BY val
				");
				$vals = implode("\n", $values);
				/*
				if ( $field['type'] == 4 ) { // radio
				} elseif ( $field['type'] == 5 ) { // dropdown
				} elseif ( $field['type'] == 7 ) { // list box
				} elseif ( $field['type'] == 8 ) { // checkbox group
				}
				*/
				// radio, dropdown, list box, checkbox group
				if ( in_array($field['type'], array(4, 5, 7, 8)) ) {
					// save as "expl"
					ac_sql_update_one("#list_field", "expl", $vals, "id = '$field[fieldid]'");
				}
			}
		}

		// reset all approvals for these lists
		$listslist = $r['relid'];
		if ( is_array($listslist) ) $listslist = implode("', '", $listslist);
		$groups = ac_sql_select_list("SELECT groupid FROM list_group WHERE listid IN ('$listslist')");
		$groupslist = implode("', '", $groups);
		ac_sql_delete("#approval", "approved = 1 AND groupid IN ('$groupslist')");
	}


	if ( $test ) {
		ac_import_log_comment(_a('Import Test Completed'));
	} else {
		ac_import_log_comment(_a('Import Completed'));
		// remove the import file
		if ( $r['filename'] and file_exists(ac_cache_dir($r['filename'])) ) {
			@unlink(ac_cache_dir($r['filename']));
		}
	}

	ac_import_log_comment(_a('Imported: ') . $r['imported']);
	ac_import_log_comment(_a('Failed: ') . $r['failed']);
	return $r;
}

function subscriber_import_src($post, $running = false) {
	// gather input
	$admin = ac_admin_get();
	$uid = ( $admin['id'] == 0 ? 1 : $admin['id'] );
	$relid = isset($post['lists']) ? $post['lists'] : 0;
	$r = array('message' => '', 'succeeded' => false);
	if ( is_array($relid) ) {
		$relid = array_diff(array_map('intval', $relid), array(0)); // don't allow zeros
		//$relid = array_map('intval', $relid); // allow zeros
		if ( !$relid ) {
			$r['message'] = _a('List not selected. Please re-run the import.');
			return $r;
		}
	} else {
		$relid = (int)$relid;
		if ( !$relid ) {
			$r['message'] = _a('List not selected. Please re-run the import.');
			return $r;
		}
	}
	$destination = (int)$post['status'];
	$delimiter = 'comma';
	// define result
	$r = array(
		'relid' => $relid,
		'valid' => false,
		'succeeded' => false,
		'message' => '',
		'filename' => '',
		'rows' => 0,
		'fields' => array(),
		'standardfields' => ac_ihook('ac_import_fields', $relid, $destination),
		'customfields' => ac_ihook('ac_import_custom_fields', $relid, $destination),
		'delimiter_file' => $delimiter,
	);
	/*
	if ( !ac_admin_isadmin() ) {
		$r['message'] = _a('Only admin users can import files.');
		return $r;
	}
	*/
	if ( !$r['customfields'] ) $r['customfields'] = array();
	// if input type is textarea, save the file for future use
	$path = ac_cache_dir() . "/";
	$filename = $post['import_file'];
	$r['filename'] = $filename;
	// do stuff with $text (data) string variable
	if ( !file_exists("$path/$filename") ) {
		$r['message'] = _a('Import file could not be found.');
		return $r;
	}

	$fp      = @fopen("$path/$filename", "r");
	$r       = array_merge($r, subscriber_import_fileinfo($fp, $delimiter));
	$r["fp"] = $fp;

	if ($r["valid"]) {
		# If valid so far, count required fields
		$required = 0;
		foreach ( $r['standardfields'] as $row ) {
			if ( $row['req'] ) $required++;
		}
		foreach ( $r['customfields'] as $row ) {
			if ( $row['req'] ) $required++;
		}
		if ( count($r['fields']) < $required ) {
			$r['message'] = sprintf(_a('This CSV file does not have enough columns to complete the import. It needs to have at least %d columns.'), $required);
			return $r;
		}
		$r['valid'] = true;
		if ( ac_ihook_exists('ac_import_valid_check') ) {
			$r['valid'] = (bool)ac_ihook('ac_import_valid_check', $r);
		}
	}

	$r["succeeded"] = true;
	$r['message'] = _a('Import content successfully parsed.');
	return $r;

	#--

	$text = file_get_contents("$path/$filename");
	// get array from CSV file
	$csv = ac_import_csv2array($text, $delimiter);
	unset($text);
	// get fields
	$r['fields'] = ac_import_columns($csv);
	// save CSV data if running
	$r['rows'] = count($csv);
	if ( $running ) $r['data'] = $csv;
	if ( count($r['fields']) == 0 ) {
		$r['message'] = _a('This is either not a CSV file, or no columns could be matched. Please try using different settings.');
		return $r;
	}
	// count required fields
	$required = 0;
	foreach ( $r['standardfields'] as $row ) {
		if ( $row['req'] ) $required++;
	}
	foreach ( $r['customfields'] as $row ) {
		if ( $row['req'] ) $required++;
	}
	if ( count($r['fields']) < $required ) {
		$r['message'] = sprintf(_a('This CSV file does not have enough columns to complete the import. It needs to have at least %d columns.'), $required);
		return $r;
	}
	$r['valid'] = true;
	if ( ac_ihook_exists('ac_import_valid_check') ) {
		$r['valid'] = (bool)ac_ihook('ac_import_valid_check', $r);
	}
	$r['succeeded'] = true;
	$r['message'] = _a('Import content successfully parsed.');
	return $r;
}

function subscriber_import_cfield_add($title, $type, $column = 0) {
	$lists = $_SESSION['subscriber_importer']['lists'];
	$r = array(
		'title' => trim((string)$title),
		'type' => (int)$type,
		'column' => (int)$column,
		'lists' => implode(',', $lists),
		'id' => 0,
	);

	if ( !$r['title'] ) {
		return ac_ajax_api_result(false, _a("Custom Field Title cannot be left empty."), $r);
	}

	// "Text Box" type can't have 0 for onfocus, for some reason; it throws a JS error when trying to load the custom field.
	// the rest seem to work fine with 0 for onfocus
	//$onfocus = ($r['type'] == 2) ? '||' : 0;
	$onfocus = '';

	$insert = array(
		'id' => 0,
		'title' => $r['title'],
		'type' => $r['type'],
		'expl' => '',
		'req' => 0,
		'onfocus' => $onfocus,
		'bubble_content' => '',
		'label' => 0,
		'show_in_list' => 1,
		'perstag' => '',
	);
	$sql = ac_sql_insert('#list_field', $insert);
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Custom Field could not be added."), $r);
	}
	$r['id'] = $id = (int)ac_sql_insert_id();
	foreach ( $lists as $lid ) {
		$insert = array(
			'id' => 0,
			'fieldid' => $id,
			'relid' => $lid,
			'dorder' => 999,
		);
		$sql = ac_sql_insert('#list_field_rel', $insert);
		if ( !$sql ) {
			return ac_ajax_api_result(false, _a("Custom Field could not be added to a list."), $r);
		}
	}

	if ( !isset($_SESSION['subscriber_importer']['newfields']) ) $_SESSION['subscriber_importer']['newfields'] = array();
	$_SESSION['subscriber_importer']['newfields'][] = array('fieldid' => $id, 'columnid' => $r['column'], 'type' => $r['type']);

	return ac_ajax_api_added(_a("Custom Field"), $r);
}

function subscriber_import_is_email($email) {
	return ac_str_instr("@", $email);
}

?>
