{literal}

var campaign_step3_backtoselect = false;
var campaign_step3_messageid    = 0;

function campaign_message_change(messageid) {
	$('step3next').disabled = ac_dom_boxempty("messageField");
	// is split, update winner window
	if ( campaign_obj.type == 'split' ) {
		var messages = ac_dom_boxchoice("messageField");
		var rel = $('messagesplitlist');
		ac_dom_showif($('messagesplitnone'), messages.length < 2);
		ac_dom_remove_children(rel);
		if ( messages.length > 0 ) {
			var total = 0;
			var options = $('messageDiv').getElementsByTagName('input');
			for ( var i = 0; i < options.length; i++ ) {
				var m = options[i];
				if ( m.checked ) {
					props = {
						id: 'splitratio' + m.value + 'field',
						name: 'splitratio[' + m.value + ']',
						type: 'text',
						style: 'width: 20px;'
					};
					// find new percentage
					if ( campaign_obj.split_type == 'even' ) {
						var perc = Math.round(100 / messages.length);
						if ( i == messages.length - 1 ) {
							// last one, do complement
							perc += 100 - ( perc * messages.length );
						}
						props.disabled = true;
						props.readonly = true;
					} else {
						if ( messages.length > 16 ) {
							var perc = 1;
						} else if ( messages.length > 8 ) {
							var perc = 5;
						} else { // 8 or less
							var perc = 10;
						}
						props.onkeyup = 'window.setTimeout(function() { return message_split_recalculate($(\'splitratio' + m.value + 'field\')); }, 100);';
					}
					props.value = perc;
					var offset = Math.round(total * 3);
					var width = Math.round(perc * 3);
					var editlink = Builder.node(
						'a',
						{
							href: 'main.php?action=message&onsave=close#form-' + m.value,
							onclick: 'if(confirm(campaign_messageedit_str))ac_ui_openwindow(this.href);return false;'
						},
						[ Builder._text(jsOptionEdit) ]
					);
					// add row
					rel.appendChild(
						Builder.node(
							'tr',
							[
								Builder.node('td', { width: 50, valign: 'middle' }, [ Builder.node('input', props) ]),
								Builder.node('td', { valign: 'middle' }, [ Builder.node('strong', [ Builder._text(m.innerHTML) ]), Builder._text(' ('), editlink, Builder._text(')') ]),
								ac_dom_emptynode('td', { width: 25 }),
								Builder.node('td', { width: 300, valign: 'middle' }, [ Builder.node('div', { style: 'border:1px solid #9EC73D;' }, [ ac_dom_emptynode('div', { style: 'background:#D5E6AC;width:' + width + 'px;margin-left:' + offset + 'px;' }) ]) ])
							]
						)
					);
					total += perc;
				}
			}
		}
		// winner ratio
		if ( campaign_obj.split_type != 'even' ) {
			// winner box
			var perc = 100 - total;
			message_winner_set(perc, total);
		} else {
			//
		}
	} else {
		ac_dom_boxclear('messageField');
		ac_dom_boxset('messageField', [ messageid ]);
		ac_dom_hideif($('editmessagebutton'), ac_dom_boxempty("messageField"));
	}
}

function campaign_step2_cb(xml) {
	var ary = ac_dom_read_node(xml);
	ac_ui_api_callback();

	if (ary.succeeded == 1) {
		ac_result_show(ary.message);
		campaign_obj.total_amt = ary.cnt;
		campaign_obj.wildcards = ary.wildcards;

		// stop them if no subscribers
		if ( campaign_obj.type != 'responder' && campaign_obj.type != 'reminder' ) {
			if ( campaign_obj.total_amt == 0 ) {
				$("nosubscribersmodal").toggle();
				stepb4 = null;
				return;
			}
		}

		if (campaign_obj.type == "split") {
			$("h2_step3_1").innerHTML = campaign_str_selectmul + "...";
		} else {
			$("h2_step3_1").innerHTML = campaign_str_selectone + "...";
		}

		if ( ac_js_admin.send_approved != 1 && ary.bapproved ) {
			ac_js_admin.send_approved = 1;
			var n = $('approvalneededwarning');
			if ( n ) n.parentNode.removeChild(n);
			var n = $('finalsubmitted');
			if ( n ) n.parentNode.removeChild(n);
		}
		// preset the panels for splits
		ac_dom_showif($('splitoptions'), campaign_obj.type == 'split');
		ac_dom_showif($('notice_activerss'), campaign_obj.type == 'activerss');
		ac_dom_showif($('splitwinner'), campaign_obj.type == 'split');
		// if split, deal with stuff within panels
		if ( campaign_obj.type == 'split' ) {
			$$("div#editOnly input.ac_button_add").each(function(e) {
				e.value = message_form_str_addmessage;
			});
			$$("div#editOnly input.ac_button_back").each(function(e) {
				e.style.float = "";
				e.value = jsCancel;
			});
			if ( campaign_obj.split_type != 'even' ) {
				// read/click
				$('splittypewinner').checked = true;
				// check whatever switch it is
				$('splitwinnertype' + campaign_obj.split_type).checked = true;
			} else {
				$('splittypeeven').checked = true;
				$('splitwinnertypeclick').checked = true;
			}
			// set offset values
			$('splitoffset').value = campaign_obj.split_offset;
			$('splitoffsettype').value = campaign_obj.split_offset_type;
			campaign_split_type( campaign_obj.split_type != 'even' ? 'winner' : 'even' );
		} else {
			// There's really only one match -- the message add button
			$$("div#editOnly input.ac_button_add").each(function(e) {
				e.value = jsNext;
			});
			$$("div#editOnly input.ac_button_back").each(function(e) {
				e.style.float = "right";
				e.value = jsBack;
			});
			$('step3next').disabled = ac_dom_boxempty("messageField");
			ac_dom_hideif($('editmessagebutton'), $('step3next').disabled);
		}
		// check if permissions are still valid
		ac_dom_showif($('campaign_send_warning'), ( ac_js_admin.pg_message_send && ary.valid != 1 ) || $('campaign_send_warning_subscriber').className == 'ac_block');
		ac_dom_showif($('campaign_send_warning_mail'), ac_js_admin.pg_message_send && ary.valid != 1);
		if ( $('step6next') ) {
			ac_dom_showif($('step6next'), ary.valid == 1 && $('campaign_send_warning_subscriber').className != 'ac_block');
		}
		// increase step
		campaign_obj.step++;
		step_update("inc");
		// if there are no messages in the system, show the create message form right away
		if ( $('messageDiv').getElementsByTagName('input').length == 0 ) {
			step_forward_message();
		}
	} else {
		ac_error_show(ary.message);
	}
}

function campaign_message_all() {
	// gather all id's?
	ac_ui_api_call(jsLoading, 60);
	ac_ajax_call_cb("api.php", "campaign.campaign_list_messages", campaign_message_all_cb, campaign_obj.type, '');
	$('campaignallmessages').hide();
	return false;
}

function campaign_message_all_cb(xml) {
	var ary = ac_dom_read_node(xml);
	ac_ui_api_callback();
	if ( ary.row && ary.row.length && ary.row.length > 0 ) {
		campaign_message_fill(ary.row);
		ac_dom_boxclear("messageField");
		$('editmessagebutton').hide();
	}
}

function campaign_message_find_toggle() {
	$('messagefind').toggle();
}

function campaign_message_find() {
	var phrase = $('messagefindphrase').value;
	// gather all id's?
	var ids = ( $('campaignallmessages').style.display == 'none' ? '' : ac_dom_boxchoice('parentsList').join(',') );
	ac_ui_api_call(jsLoading, 60);
	ac_ajax_call_cb("api.php", "campaign.campaign_list_messages", campaign_message_find_cb, campaign_obj.type, ids, phrase);
	return false;
}

function campaign_message_find_cb(xml) {
	var ary = ac_dom_read_node(xml);
	ac_ui_api_callback();
	if ( ary.row && ary.row.length && ary.row.length > 0 ) {
		campaign_message_fill(ary.row);
		ac_dom_boxclear("messageField");
		$('editmessagebutton').hide();
		$('messagefindreset').show();
		ac_result_show(sprintf(campaign_message_search_found, ary.row.length));
	} else {
		ac_error_show(sprintf(campaign_message_search_found, '0'));
	}
}

function campaign_message_reset() {
	$('messagefindphrase').value = '';
	$('messagefindreset').hide();
	$('campaignallmessages').show();

	ac_dom_remove_children($('messagesplitlist'));
	$('messagesplitnone').show();

	// gather all id's?
	ac_ui_api_call(jsLoading, 60);
	ac_ajax_call_cb("api.php", "campaign.campaign_list_messages", campaign_message_all_cb, campaign_obj.type, ac_dom_boxchoice('parentsList').join(','));
}

function campaign_message_create() {
	if ( $('messagenew').style.display != 'none') {
		$('messagenew').hide();
		$('usemessage').show();
		$('step3buttons').show();
		if (ac_dom_boxempty("messageField")) {
			$('step3next').disabled = false;
			ac_dom_hideif($('editmessagebutton'), campaign_obj.type == 'split');
		}
		return;
	}
	message_defaults();
	$('splitoptions').hide();
	$('splitwinner').hide();
	//customFieldsObj.fetch(0);
	if (message_form_templatecount > 0 || message_form_messagecount > 0) {
		$('addOnly').show();
		$('editOnly').hide();
		$('h2_step3_1').hide(); // <h2>
		$('addtitle0').hide(); // <h1>
		$('addtitle1').show(); // <h2>
		$('addtitle').hide(); // <h1>
		$('addtitle2').show(); // <h2>
		message_preview("template", "");
	} else {
		$('addOnly').hide();
		$('editOnly').show();
	}
	ac_ui_api_call(jsLoading, 60);
	ac_ajax_call_cb("api.php", "message.message_select_list", campaign_message_create_cb, 50);
}

function campaign_message_create_cb(xml) {
	var ary = ac_dom_read_node(xml);
	ac_ui_api_callback();
	if ( ary.row && ary.row.length && ary.row.length > 0 ) {
		$('messageUseBox').show();
		var rel = $('messageUseList');
		ac_dom_remove_children(rel);
		for ( var i = 0; i < ary.row.length; i++ ) {
			var m = ary.row[i];
			rel.appendChild(
				Builder.node('option', { value: m.id }, [ Builder._text(strip_tags(m.subject, true)) ])
			);
		}
		rel.selectedIndex = 0;
	} else {
		$('messageUseBox').hide();
	}
	$('messagenew').show();
	$('usemessage').hide();
	$('step3buttons').hide();
	$('step3_select').show();
	//$('step3next').disabled = true;
}

function campaign_split_type(newval) {
	ac_dom_showif($('splittypewinnerbox'), newval != 'even');
	ac_dom_showif($('winneronly'), newval != 'even');
	if ( newval != 'even' ) {
		if ( !$('splitwinnertyperead').checked && !$('splitwinnertypeclick').checked ) {
			$('splitwinnertypeclick').checked = true;
			newval = 'click';
		} else {
			newval = ( $('splitwinnertyperead').checked ? 'read' : 'click' );
		}
		campaign_split_label_offset();
		campaign_split_label_offsettype();
		//$('splitwinnertype' + campaign_obj.split_type).checked = true;
	} else {
		//
	}
	campaign_obj.split_type = newval;
	campaign_message_change();
}

function campaign_split_label_offset() {
	$('splitoffsetlabel').innerHTML = $('splitoffset').value + ' ' + campaign_split_offsets[$('splitoffsettype').value];
}

function campaign_split_label_offsettype() {
	$('splitoffsettypelabel').innerHTML = campaign_split_types[( $('splitwinnertypeclick').checked ? 'click' : 'read' )];
}

function message_split_sumup() {
	var total = 0;
	var rel = $('messagesplitlist');
	var inputs = rel.getElementsByTagName('input');
	for ( var i = 0; i < inputs.length; i++ ) {
		var perc = parseInt(inputs[i].value, 10);
		if ( perc == 0 ) return false;
		total += perc;
		if ( total >= 100 ) {
			return false;
		}
	}
	return total;
}

function message_split_recalculate(obj) {
	if ( !ac_ui_numbersonly(obj) ) return false;
	if ( !message_split_sumup() ) return false;
	total = 0;
	// all good, go through all and set bars
	var rel = $('messagesplitlist');
	var inputs = rel.getElementsByTagName('input');
	for ( var i = 0; i < inputs.length; i++ ) {
		var perc = parseInt(inputs[i].value, 10);
		//var id = parseInt(inputs[i].name.replace('splitratio[').replace(']'), 10);
		var offset = Math.round(total * 3);
		var width = Math.round(perc * 3);
		// update bar(s)
		var tr = inputs[i].parentNode.parentNode;
		var td = tr.getElementsByTagName('td')[3];
		var bar = td.getElementsByTagName('div')[1];
		bar.style.width = width + 'px';
		bar.style.marginLeft = offset + 'px';
		total += perc;
	}
	message_winner_set(perc, total);
}

function message_winner_set(perc, total) {
	var perc = 100 - total;
	var offset = Math.round(total * 3);
	var width = Math.round(perc * 3);
	$('winnerratio').value = perc;
	$('winnerbar').style.width = width + 'px';
	$('winnerbar').style.marginLeft = offset + 'px';
}

function campaign_split_offset_changed() {
	window.setTimeout(
		function() {
			if ( !ac_ui_numbersonly($('splitoffset'), true) ) return false;
			campaign_split_label_offset();
		},
		100
	);
}

function campaign_step3_back(editingmessage) {
	$('step3_select').hide();

	if (campaign_obj.type == 'split') {
		if (campaign_step3_backtoselect) {
			campaign_step3_backtoselect = false;
			$('usemessage').show();
			$('messagenew').hide();
			$('step3_select').show();
			$('splitoptions').show();
			$('splitwinner').show();
		} else {
			step_back();
		}
	} else {
		if (editingmessage) {
			$('editOnly').hide();
			$('addOnly').show();
			$('step3buttons').hide();
			$('step3_select').show();
		} else {
			$('messagenew').hide();
			$('usemessage').show();
			$('step3buttons').show();
			$('step3').show();
		}
	}
}

function campaign_messages_count() {
	var cnt = 0;

	for ( var i in campaign_obj.messages ) {
		var m = campaign_obj.messages[i];
		if ( typeof m != 'function' ) {
			cnt++;
		}
	}

	return cnt;
}

{/literal}
