//ac_editor_init_normal_object.plugins += ",ota_personalize,ota_activerss,ota_conditional,ota_template";
//ac_editor_init_normal_object.theme_advanced_buttons1 += ",ota_personalize,ota_activerss,ota_conditional,ota_template";
ac_editor_init_normal_object.mode = "none";
ac_editor_init_normal_object.elements = "unsubEditor";

//ac_editor_init_normal();

{literal}

function campaign_step3_cb(xml) {
	var ary = ac_dom_read_node(xml);
	ac_ui_api_callback();
	if ( !ary.row ) {
		ac_error_show(message_form_str_cant_find);
		return;
	}
	$("step3_select").hide();
	// save message info
	campaign_obj.messages = ary.row;
	// prepare campaign object
	campaign_obj.links = [];
	campaign_obj.actions = [];
	campaign_obj.linkmessages = [];
	// set link tracking
	campaign_message_tracklinks_set();
	campaign_actions_set(0, 'open', []);
	// set unsub link panel
	campaign_message_unsub_set();
	// other options stuff
	var bouncescnt = $('bounceField').getElementsByTagName('option').length;
	if (campaign_message_format_sum() != 'text' && campaign_message_embedimages_sum() > 0) {
		$('message_embed').show();
	} else {
		$('message_embed').hide();
	}
	$('embedimages').checked = ( campaign_obj.embed_images == 1 );

	/*
	if (bouncescnt > 1)
		$('message_bounceid').show();
	else
		$('message_bounceid').hide();
	*/
	$('message_bounceid').hide(); // we decided to hide this section completely in 5.2 (it should still work though)

	if (bouncescnt > 2)
		$('bouncespecifylink').show();
	else
		$('bouncespecifylink').hide();

	$('usebounce').checked = ( bouncescnt > 0 && campaign_obj.bounceid != 0 );

	if (campaign_obj.perms.private != 1)
		$('message_public').show();
	else
		$('message_public').hide();

	$('publiccheck').checked = ( campaign_obj.perms.private != 1 && campaign_obj.public == 1 );
	// fix for a swiftmailer prob with using embedder with attachments
	var foundAttachments = false;
	for ( var i in campaign_obj.messages ) {
		var m = campaign_obj.messages[i];
		if ( typeof m != 'function' ) {
			if ( m.filescnt > 0 ) {
				foundAttachments = true;
				break;
			}
		}
	}
	$('embedimagescolumn').style.color = ( foundAttachments ? '#999' : '#000' );

	if (foundAttachments)
		$('embedimagesalert').show();
	else
		$('embedimagesalert').hide();

	$('embedimages').disabled = foundAttachments;

	if (campaign_has_readactions()) {
		var count = 0;
		for (var i in campaign_obj.readactions[0].parts) {
			if (typeof i == "string") {
				if (typeof campaign_obj.readactions[0].parts[i].act != "undefined")
					count++;
			}
		}

		$("messagelinkactionsopen").innerHTML = sprintf(campaign_actionscnt_str, count);
	}

	// increase step
	campaign_obj.step++;
	step_update("inc");
}

function campaign_readactions_set() {
	var actions = [];

	if (campaign_has_readactions()) {
		for (var i in campaign_obj.readactions[0].parts) {
			var a = campaign_obj.readactions[0].parts[i];

			if (typeof a != "function") {
				actions.push(a.parts[k]);
			}
		}
	}
}

function campaign_links_set(l) {
	// try to find any existing actions and names
	var found = (
		campaign_obj.tracklinks != 'none' &&
		campaign_obj.perms.p_use_tracking == 1 &&
		campaign_message_links_sum() > 0 &&
		(
			campaign_message_tracklinks_sum() == 0 ||
			campaign_message_tracklinks_sum() == campaign_message_links_sum()
		)
	);
	var actions = [];
	var linkname = (l.format == 'html') ? l.title : '';
	for ( var i in campaign_obj.tlinks ) {
		var t = campaign_obj.tlinks[i];
		if ( typeof t != 'function' ) {
			if ( l.link == t.link && l.messageid == t.messageid ) {
				found = true;
				linkname = t.name;
				if (linkname === null)
					linkname = "";
				for ( var j in t.actions ) {
					var a = t.actions[j];
					if ( typeof a != 'function' ) {
						for (var k in a.parts) {
							if (typeof a.parts[k] != 'function')
								actions.push(a.parts[k]);
						}
					}
				}
			}
		}
	}
	// try to figure out link name
	if ( linkname == '' ) {
		// update subscriber
		var murl = plink + '/p_m.php';
		if ( l.link.substr(0, murl.length).toLowerCase() == murl.toLowerCase() ) {
			linkname = strTrackUpdateSubscriberName;
		}
		// web copy
		var murl = plink + '/p_v.php';
		if ( l.link.substr(0, murl.length).toLowerCase() == murl.toLowerCase() ) {
			linkname = strTrackWebCopyName;
		}
		// forward2friend
		var murl = plink + '/p_f.php';
		if ( l.link.substr(0, murl.length).toLowerCase() == murl.toLowerCase() ) {
			linkname = strTrackForward2FriendName;
		}
	}
	// try to find that link in campaign_obj.tracklinks
	var linkidx = campaign_actions_set(l.messageid, l.link, actions);
	var props = {
		id: 'messagelinktrack' + linkidx,
		href: '#',
		name: 'linkurl[' + linkidx + ']',
		type: 'checkbox',
		value: l.link,
		onclick: 'if(!this.checked)$(\'linksselectall\').checked=false;'
	};
	if ( found ) {
		props.checked = 'checked';
	}
	return Builder.node(
		'tr',
		[
			Builder.node(
				'td',
				{ align: 'center' },
				[ Builder.node('input', props) ]
			),
			Builder.node(
				'td',
				{ width: '16' },
				[
					Builder.node(
						'a',
						{ href: l.link, target: '_blank' },
						[
							Builder.node('img', { src: 'images/windows-16-16.png', width: '16', height: '16', border: '0' })
						]
					)
				]
			),
			Builder.node(
				'td',
				[ Builder._text(ac_str_middleshorten(l.link, 30, 30)) ]
			),
			Builder.node(
				'td',
				[
					Builder.node(
						'a',
						{
							id: 'messagelinkactions' + linkidx,
							href: '#',
							onclick: sprintf("return campaign_actions('%s', '%s', '%s', '%s')", l.messageid, ac_b64_encode(l.link), linkidx, l.id)
						},
						[ Builder._text(sprintf(campaign_actionscnt_str, actions.length)) ]
					)
				]
			),
			Builder.node(
				'td',
				[
					Builder.node('input', { name: 'linkname[' + linkidx + ']', type: 'text', value: linkname, style: 'width:175px;' }),
					Builder.node('input', { name: 'linkmessage[' + linkidx + ']', type: 'hidden', value: l.messageid }),
					Builder.node('input', { name: 'linkaction[' + linkidx + ']', id: 'linkaction' + linkidx, type: 'hidden', value: "0" })
				]
			)
		]
	);
}

function campaign_message_embedimages_sum() {
	var sum = 0;
	for ( var i in campaign_obj.messages ) {
		var m = campaign_obj.messages[i];
		if ( typeof m != 'function' ) {
			if ( m.images ) {
				sum += m.images.length;
			}
		}
	}
	return sum;
}

function campaign_message_tracklinks_sum() {
	var sum = 0;
	for ( var i in campaign_obj.tlinks ) {
		var t = campaign_obj.tlinks[i];
		if ( typeof t != 'function' ) {
			sum++;
		}
	}
	return sum;
}

function campaign_message_links_sum() {
	var sum = 0;
	for ( var i in campaign_obj.messages ) {
		var m = campaign_obj.messages[i];
		if ( typeof m != 'function' ) {
			if ( m.links ) {
				sum += m.links.length;
			}
		}
	}
	return sum;
}

function campaign_message_format_sum() {
	var text = false;
	var html = false;
	var mime = false;
	for ( var i in campaign_obj.messages ) {
		var m = campaign_obj.messages[i];
		if ( typeof m != 'function' ) {
			// mime check
			if ( m.format == 'mime' ) return 'mime';
			// html check
			if ( m.format == 'html' ) {
				if ( text ) return 'mime';
				html = true;
			}
			// text check
			if ( m.format == 'text' ) {
				if ( html ) return 'mime';
				text = true;
			}
		}
	}
	return ( html ? 'html' : 'text' );
}

function campaign_message_tracklinks_set() {
	var setval = ( campaign_obj.tracklinks != 'none' && campaign_obj.perms.p_use_tracking == 1 && campaign_message_links_sum() > 0 ? 'specific' : 'none' );
	if ( setval == 'specific' ) {
		if ( campaign_message_tracklinks_sum() == 0 || campaign_message_tracklinks_sum() == campaign_message_links_sum() ) {
			setval = 'all';
		}
	}
	if ( campaign_obj.perms.p_use_tracking == 1 && campaign_message_links_sum() > 0 )
		$('message_tlinks_box').show();
	else
		$('message_tlinks_box').hide();

	// add all links
	var relhtml = $('tlinkshtmllist');
	var reltext = $('tlinkstextlist');
	ac_dom_remove_children(relhtml);
	ac_dom_remove_children(reltext);

	if (typeof campaign_obj.tlinks[0] != "undefined") {
		for (var i in campaign_obj.tlinks) {
			var l = campaign_obj.tlinks[i];
			if (typeof l != "function") {
				if (l.format == "html")
					relhtml.appendChild(campaign_links_set(l));
				else
					reltext.appendChild(campaign_links_set(l));
			}
		}
	} else {
		for ( var i in campaign_obj.messages ) {
			var m = campaign_obj.messages[i];
			if ( typeof m != 'function' ) {
				if ( m.links ) {
					for ( var j in m.links ) {
						var l = m.links[j];
						if ( typeof l != 'function' ) {
							if ( l.format == 'html' ) relhtml.appendChild(campaign_links_set(l));
							else reltext.appendChild(campaign_links_set(l));
						}
					}
				}
			}
		}
	}
	$('trackreads').checked = ( campaign_message_format_sum() != 'text' ? campaign_obj.trackreads == 1 : false );
	// now select the panel that will be used
	$('tracklinks' + setval).checked = true;
	if ( setval != 'none' ) {
		$('message_tlinks_' + setval + '_format').value = 'html';
		$('linksselectall').checked = ( setval == 'all' );
		//ac_form_check_selection_element_all('tlinkshtmllist', $('linksselectall').checked);
		//ac_form_check_selection_element_all('tlinkstextlist', $('linksselectall').checked);
	}
	//$('tracklinksformatall').value = 'html';
	campaign_message_tracklinks(setval, true);
}

function campaign_message_tracklinks(newval, dontUpdate) {
	ac_dom_showif($('message_tlinks_all_format'), newval == 'all' && campaign_message_format_sum() == 'mime');
	ac_dom_showif($('message_tlinks_list'), newval == 'specific');
	ac_dom_showif($('message_tlinks_specific_format'), newval == 'specific' && campaign_message_format_sum() == 'mime');
	ac_dom_hideif($('message_treads'), newval == 'none' && campaign_message_format_sum() == 'text');
	ac_dom_hideif($('message_analytics_read'), newval == 'none' && campaign_message_format_sum() == 'text' && !$('trackreads').checked);
	if ( campaign_obj.perms.p_use_analytics_read != 1 ) $('message_analytics_read').hide();
	ac_dom_showif($('message_analytics_link'), newval != 'none' && campaign_message_links_sum() > 0 && campaign_obj.perms.p_use_analytics_link == 1);
	//$('analyticsreaddisabled').disabled = !( campaign_obj.perms.p_use_analytics_read == 1 );
	$('analyticsread').checked = ( campaign_obj.perms.p_use_analytics_read == 1 && campaign_obj.trackreadsanalytics == 1 );
	//$('analyticslinkdisabled').disabled = !( campaign_obj.perms.p_use_analytics_link == 1 );
	$('analyticslink').checked = ( campaign_obj.perms.p_use_analytics_link == 1 && campaign_obj.tracklinksanalytics == 1 );
	ac_dom_showif($('message_tweet'), campaign_obj.perms.p_use_twitter == 1);
	ac_dom_showif($('message_facebook'), campaign_obj.perms.p_use_facebook == 1);
	if ( ac_js_site.facebook_app_id == "" || ac_js_site.facebook_app_secret == "" ) $('message_facebook').hide();
	$('tweet').checked = ( campaign_obj.perms.p_use_twitter == 1 && campaign_obj.tweet == 1 );
	$('facebook').checked = ( campaign_obj.perms.p_use_facebook == 1 && campaign_obj.facebook == 1 );
	if ( !dontUpdate ) {
		ac_form_check_selection_element_all('tlinkshtmllist', newval != 'none');
		ac_form_check_selection_element_all('tlinkstextlist', newval != 'none');
	}
}

function campaign_message_tracklinks_format(newval, showLinks) {
	ac_dom_showif($('tlinkshtmllist'), showLinks && newval != 'text');
	ac_dom_showif($('tlinkstextlist'), showLinks && newval != 'html');
	ac_form_check_selection_element_all('tlinkshtmllist', newval != 'text');
	ac_form_check_selection_element_all('tlinkstextlist', newval != 'html');
}

function campaign_message_unsub_has(str) {
	if ( str.indexOf('%UNSUBSCRIBELINK%') != -1 ) return true;
	var murl = plink + '/box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2';
	if ( str.indexOf(murl) != -1 ) return true;
	return false;
}

function campaign_message_unsub_check(searchOnly) {
	if ( typeof ourcustomhostedflag != 'undefined' ) return true;
	//if ( ac_js_admin.optinconfirm == 0 ) return true;
	for ( var i in campaign_obj.messages ) {
		var m = campaign_obj.messages[i];
		if ( typeof m != 'function' ) {
			if ( searchOnly != 'html' ) {
				// check text
				if ( m.format != 'html' ) {
					if ( !campaign_message_unsub_has(m.text) ) return false;
				}
			}
			if ( searchOnly != 'text' ) {
				// check html
				if ( m.format != 'text' ) {
					if ( !campaign_message_unsub_has(m.html) ) return false;
				}
			}
		}
	}
	return true;
}

function campaign_message_unsub_set() {
	var unsubmark = parseInt(campaign_obj.htmlunsub, 10) + parseInt(campaign_obj.textunsub, 10);
	campaign_obj.htmlunsub = ( !campaign_message_unsub_check('html') && campaign_obj.htmlunsub ? 1 : 0 );
	campaign_obj.textunsub = ( !campaign_message_unsub_check('text') && campaign_obj.textunsub ? 1 : 0 );
	ac_form_value_set($('unsubEditor'), campaign_obj.htmlunsubdata);
	ac_form_value_set($('includeunsubtext'), campaign_obj.textunsubdata);
	var setval = ( typeof ourcustomhostedflag == 'undefined' && !campaign_message_unsub_check() && ( campaign_obj.htmlunsub || campaign_obj.textunsub ) ? 'yes' : 'no' );
	if ( setval == 'yes' && unsubmark == 0 ) setval = 'no';
	$('includeunsub' + setval).checked = true;
	//ac_dom_showif($('message_unsub_box'), setval == 'yes');
	ac_dom_showif($('message_unsub_box'), typeof ourcustomhostedflag == 'undefined' && !campaign_message_unsub_check());
	campaign_message_unsub(setval);
}

function campaign_message_unsub(newval) {
	ac_dom_showif($('includeunsubhtmlbox'), newval == 'yes' && campaign_obj.htmlunsub == 1);
	ac_dom_showif($('includeunsubtextbox'), newval == 'yes' && campaign_obj.textunsub == 1);
}

{/literal}
