{literal}


function campaign_open_emailtest() {
	ac_dom_toggle_display('send_test_email', 'block');
	// set split message box
	if ( campaign_obj.type == 'split' )
		$('testemailsplitbox').show();
	else
		$('testemailsplitbox').hide();
	// get message id
	if ( $('testemailsplit').selectedIndex != -1 ) {
		var msg = $('testemailsplit').value;
	} else {
		var msg = campaign_obj.messages[0].id;
	}
	// set format
	campaign_set_emailtest(msg);
	$('subscriberEmailTestField').focus(); // set focus to "To email" textbox (in Send test email modal), IE won't let you edit the field otherwise
}

function campaign_set_emailtest(msg) {
	if ( !isNaN(parseInt(msg, 10)) ) {
		msg = parseInt(msg, 10);
		// find message
		for ( var i in campaign_obj.messages ) {
			var m = campaign_obj.messages[i];
			if ( typeof m != 'function' ) {
				if ( msg == m.id ) {
					msg = m;
					break;
				}
			}
		}
	}
	if ( typeof msg.format == 'undefined' ) return;
	// set format
	$('testemailtype').value = msg.format;
	// show format select?
	if (msg.format == 'mime') {
		$('testemailtype').show();
		$('testemailtypelabel').show();
	} else {
		$('testemailtype').hide();
		$('testemailtypelabel').hide();
	}
}

function campaign_send_emailtest() {
	var post = campaign_post_prepare();

	if(!post.testemail) 
		post.testemail = document.getElementById('subscriberEmailTestField').value;

	// check for email validity
	var test_email = $('subscriberEmailTestField').value; // use DOM ID to grab value
	post.testemail = test_email; // reset post value (shows up as "undefined" in IE, for some reason)
	if ( !ac_str_email(test_email) ) {
		alert(strEmailNotEmail);
		$('subscriberEmailTestField').focus();
		return;
	}
	// check if split
	if ( campaign_obj.type == 'split' ) {
		// check if any messages are selected
		if ( $('testemailsplit').selectedIndex == -1 ) {
			alert(campaign_nomessage_str);
			return;
		}
	} else {
		// assign the only message
		post.testemailsplit = ac_dom_boxchoice("messageField")[0];
	}
	ac_ui_api_call(jsSending, 60);
	ac_ajax_handle_text = campaign_send_emailtest_cb_txt;
	ac_ajax_post_cb("api.php", "campaign.campaign_send_emailtest", campaign_send_emailtest_cb, post);
}

function campaign_send_emailtest_cb_txt(txt) {
	ac_ui_error_mailer(txt, 'send_test_email');
}

function campaign_send_emailtest_cb(xml) {
	// now reset the text handler
	ac_ajax_handle_text = null;
	var ary = ac_dom_read_node(xml);
	ac_ui_api_callback();

	if (ary.succeeded != "0") {
		ac_result_show(ary.message);
		// don't show any results here, just close the modal
		ac_dom_toggle_display('send_test_email', 'block');
	} else {
		ac_error_show(ary.message);
	}
}


function campaign_open_preview() {
	var url = 'preview.php?c=' + campaign_obj.id + '&m=' + campaign_obj.messages[0].id + '&s=0';
	var w = window.open(
		url,
		'previewcampaign',
		'width=650,height=500,toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,copyhistory=yes,resizable=yes'
	);
	if ( !w ) {
		alert('Popup could not be opened.');
	}
	if ( w.focus ) w.focus();
	return;
}

function campaign_open_preview_client() {
	var url = 'preview_client.php?c=' + campaign_obj.id + '&m=' + campaign_obj.messages[0].id + '&s=';
	var w = window.open(
		url,
		'previewclient',
		'width=900,height=600,toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,copyhistory=yes,resizable=no'
	);
	if ( !w ) {
		alert('Popup could not be opened.');
	}
	if ( w.focus ) w.focus();
	return;
}

{/literal}
