var message_table = new ACTable();
var message_list_sort = "05D";
var message_list_offset = "0";
var message_list_filter = {jsvar var=$filterid};
var message_list_sort_discerned = false;

var message_list_attachments_str = '{"Attachments:"|alang|js}';

{literal}
message_table.setcol(0, function(row) {
	return Builder.node("input", { type: "checkbox", name: "multi[]", value: row.id, onclick: "ac_form_check_selection_none(this, $('acSelectAllCheckbox'), $('selectXPageAllBox'))" });
});

message_table.setcol(1, function(row) {
	var edit = Builder.node("a", { href: sprintf("#form-%d", row.id) }, jsOptionEdit);
	var dele = Builder.node("a", { href: sprintf("#delete-%d", row.id) }, jsOptionDelete);

	var ary = [];

	if (ac_js_admin.pg_message_edit) {
		ary.push(edit);
		ary.push(" ");
	}

	if (ac_js_admin.pg_message_delete) {
		ary.push(dele);
	}

	return Builder.node("div", { className: "ac_table_row_options" }, ary);
});

message_table.setcol(2, function(row) {
	var msg = row.fromemail;
	if ( row.fromname != '' ) msg = '"' + row.fromname + '" <' + msg + '>';
	return Builder._text(msg);
});

message_table.setcol(3, function(row) {
	if ( row.files && row.files.length > 0 ) {
		// "attachment" tooltip
		var msg = message_list_attachments_str + '<br />';
		for ( var i = 0; i < row.files.length; i++ ) {
			msg += row.files[i].name + ' (' + row.files[i].humansize + ')<br />';
		}
		return Builder.node(
			'img',
			{
				src: 'images/document_attachment.png',
				onmouseout: "ac_tooltip_hide();",
				onmouseover: sprintf("ac_tooltip_show('%s', 150, '', false);", msg)
			}
		);
	} else {
		return Builder._text(' ');
	}
});

message_table.setcol(4, function(row) {
	return Builder._text(strip_tags(row.subject, true));
});

message_table.setcol(5, function(row) {
	return Builder._text(row.format.toUpperCase());
});

message_table.setcol(6, function(row) {
	return Builder._text(parseInt(row.lists));
});

function message_list_anchor() {
	return sprintf("list-%s-%s-%s", message_list_sort, message_list_offset, message_list_filter);
}

function message_list_tabelize(rows, offset) {
	if (rows.length < 1) {
		if (!message_list_filter || message_list_filter == 0) {
			ac_ui_api_callback();
			ac_ui_anchor_set('form-0');
			return;
		}
		// We may have some trs left if we just deleted the last row.
		ac_dom_remove_children($("list_table"));

		$("list_noresults").show();
		if ($("list_delete_button") !== null)
			$("list_delete_button").hide();
		$("loadingBar").hide();
		ac_ui_api_callback();
		return;
	}
	$("list_noresults").hide();
	if ($("list_delete_button") !== null)
		$("list_delete_button").show();
	ac_paginator_tabelize(message_table, "list_table", rows, offset);
	$("message_list_count").innerHTML = " (" + ac_number_format(paginators[1].total, decimalDelim, commaDelim) + ")";
	$("message_list_count").show();
	if ( $('selectXPageAllBox') ) {
		var spans = $('selectXPageAllBox').getElementsByTagName('span');
		if ( spans.length > 2 ) {
			spans[2].innerHTML = ac_number_format(paginators[1].total, decimalDelim, commaDelim);
		}
	}
	$("loadingBar").hide();
}

// This function should only be run through a paginator (e.g., paginators[n].paginate(offset))
function message_list_paginate(offset) {
	if (!ac_loader_visible() && !ac_result_visible() && !ac_error_visible())
		ac_ui_api_call(jsLoading);

	if (message_list_filter > 0)
		$("list_clear").style.display = "inline";
	else
		$("list_clear").style.display = "none";

	message_list_offset = parseInt(offset, 10);

	ac_ui_anchor_set(message_list_anchor());
	$("loadingBar").show();
	ac_ajax_call_cb(this.ajaxURL, this.ajaxAction, paginateCB, this.id, message_list_sort, message_list_offset, this.limit, message_list_filter);

	$("list").show();
}

function message_list_clear() {
	message_list_sort = "02";
	message_list_offset = "0";
	message_list_filter = "0";
	message_listfilter = null;
	$("JSListManager").value = 0;
	$("JSFormatManager").value = "";
	$("list_search").value = "";
	list_filters_update(0, 0, true);
	message_search_defaults();
	ac_ui_anchor_set(message_list_anchor());
}

function message_list_search() {
	var post = ac_form_post($("list"));
	message_listfilter = post.listid;
	list_filters_update(0, post.listid, false);
	ac_ajax_post_cb("api.php", "message.message_filter_post", message_list_search_cb, post);
}

function message_list_search_cb(xml) {
	var ary = ac_dom_read_node(xml);

	message_list_filter = ary.filterid;
	ac_ui_anchor_set(message_list_anchor());
}

function message_list_chsort(newSortId) {
	var oldSortId = ( message_list_sort.match(/D$/) ? message_list_sort.substr(0, 2) : message_list_sort );
	var oldSortObj = $('list_sorter' + oldSortId);
	var sortObj = $('list_sorter' + newSortId);
	// if sort column didn't change (only direction [asc|desc] did)
	if ( oldSortId == newSortId ) {
		// switching asc/desc
		if ( message_list_sort.match(/D$/) ) {
			// was DESC
			newSortId = message_list_sort.substr(0, 2);
			sortObj.className = 'ac_sort_asc';
		} else {
			// was ASC
			newSortId = message_list_sort + 'D';
			sortObj.className = 'ac_sort_desc';
		}
	} else {
		// remove old message_list_sort
		if ( oldSortObj ) oldSortObj.className = 'ac_sort_other';
		// set sort field
		sortObj.className = 'ac_sort_asc';
	}
	message_list_sort = newSortId;
	ac_ui_api_call(jsSorting);
	ac_ui_anchor_set(message_list_anchor());
	return false;
}

function message_list_discern_sortclass() {
	if (message_list_sort_discerned)
		return;

	var elems = $("list_head").getElementsByTagName("a");

	for (var i = 0; i < elems.length; i++) {
		var str = sprintf("list_sorter%s", message_list_sort.substring(0, 2));

		if (elems[i].id == str) {
			if (message_list_sort.match(/D$/))
				elems[i].className = "ac_sort_desc";
			else
				elems[i].className = "ac_sort_asc";
		} else {
			elems[i].className = "ac_sort_other";
		}
	}

	message_list_sort_discerned = true;
}

{/literal}
