var optinoptout_table = new ACTable();
var optinoptout_list_sort = "01";
var optinoptout_list_offset = "0";
var optinoptout_list_filter = {jsvar var=$filterid};
var optinoptout_list_sort_discerned = false;

var optinoptout_list_attachments_str = '{"Attachments:"|alang|js}';

{literal}
optinoptout_table.setcol(0, function(row) {
	if ( row.id != 1 ) {
		return Builder.node("input", { type: "checkbox", name: "multi[]", value: row.id, onclick: "ac_form_check_selection_none(this, $('acSelectAllCheckbox'), $('selectXPageAllBox'))" });
	} else {
		return Builder._text(" ");
	}
});

optinoptout_table.setcol(1, function(row) {
	var edit = Builder.node("a", { href: sprintf("#form-%d", row.id) }, jsOptionEdit);
	var dele = Builder.node("a", { href: sprintf("#delete-%d", row.id) }, jsOptionDelete);

	var ary = [];

	if (ac_js_admin.pg_list_edit) {
		ary.push(edit);
		ary.push(" ");
	}

	if ( row.id != 1 ) {
		if (ac_js_admin.pg_list_edit) {
			ary.push(dele);
		}
	} else {
		ary.push(Builder.node("strong", [ Builder._text(jsDefault) ]));
	}

	return Builder.node("div", { className: "ac_table_row_options" }, ary);
});

optinoptout_table.setcol(2, function(row) {
	if ( row.name != '' ) {
		return Builder._text(row.name);
	} else {
		return Builder.node('em', [ Builder._text(jsNotAvailable) ]);
	}
});

optinoptout_table.setcol(3, function(row) {
	if ( row.optin_files && row.optin_files.length > 0 ) {
		// "attachment" tooltip
		var msg = optinoptout_list_attachments_str + '<br />';
		for ( var i = 0; i < row.optin_files.length; i++ ) {
			msg += row.optin_files[i].name + ' (' + row.optin_files[i].humansize + ')<br />';
		}
		return Builder.node(
			'img',
			{
				src: 'images/document_attachment.png',
				onmouseout: "ac_tooltip_hide();",
				onmouseover: "ac_tooltip_show('" + ac_b64_encode(msg) + "', 150, '', true);"
			}
		);
	} else {
		return Builder._text(' ');
	}
});

optinoptout_table.setcol(4, function(row) {
	if ( row.optin_confirm == 1 ) {
		// "from" tooltip
		var tooltip = { style: "width: 100%;" };
		if ( row.optin_from_email != '' ) {
			var msg = row.optin_from_email;
			if ( row.optin_from_name != '' ) msg = '"' + row.optin_from_name + '" <' + msg + '>';
			tooltip.onmouseout = "ac_tooltip_hide();";
			tooltip.onmouseover = "ac_tooltip_show('" + msg + "', 200);";
		}
		return Builder.node("div", tooltip, [ Builder._text(row.optin_subject) ]);
	} else {
		return Builder.node('em', [ Builder._text(jsNone) ]);
	}
});

optinoptout_table.setcol(5, function(row) {
	if ( row.optout_files && row.optout_files.length > 0 ) {
		// "attachment" tooltip
		var msg = 'Attachments:' + '<br />';
		for ( var i = 0; i < row.optout_files.length; i++ ) {
			msg += row.optout_files[i].name + ' (' + row.optout_files[i].humansize + ')<br />';
		}
		return Builder.node(
			'img',
			{
				src: 'images/document_attachment.png',
				onmouseout: "ac_tooltip_hide();",
				onmouseover: "ac_tooltip_show('" + ac_b64_encode(msg) + "', 150, '', true);"
			}
		);
	} else {
		return Builder._text(' ');
	}
});

optinoptout_table.setcol(6, function(row) {
	if ( row.optout_confirm == 1 ) {
		// "from" tooltip
		var tooltip = { style: "width: 100%;" };
		if ( row.optout_from_email != '' ) {
			var msg = row.optout_from_email;
			if ( row.optout_from_name != '' ) msg = '"' + row.optout_from_name + '" <' + msg + '>';
			tooltip.onmouseout = "ac_tooltip_hide();";
			tooltip.onmouseover = "ac_tooltip_show('" + msg + "', 200);";
		}
		return Builder.node("div", tooltip, [ Builder._text(row.optout_subject) ]);
	} else {
		return Builder.node('em', [ Builder._text(jsNone) ]);
	}
});

optinoptout_table.setcol(7, function(row) {
	return Builder._text(parseInt(row.lists));
});

function optinoptout_list_anchor() {
	return sprintf("list-%s-%s-%s", optinoptout_list_sort, optinoptout_list_offset, optinoptout_list_filter);
}

function optinoptout_list_tabelize(rows, offset) {
	if (rows.length < 1) {
		if (!optinoptout_list_filter || optinoptout_list_filter == 0) {
			ac_ui_api_callback();
			ac_ui_anchor_set('form-0');
			return;
		}
		// We may have some trs left if we just deleted the last row.
		ac_dom_remove_children($("list_table"));

		$("list_noresults").className = "ac_block";
		if ($("list_delete_button") !== null)
			$("list_delete_button").className = "ac_hidden";
		$("loadingBar").className = "ac_hidden";
		ac_ui_api_callback();
		return;
	}
	$("list_noresults").className = "ac_hidden";
	if ($("list_delete_button") !== null)
		$("list_delete_button").className = "ac_inline";
	ac_paginator_tabelize(optinoptout_table, "list_table", rows, offset);

	$("optinoptout_list_count").innerHTML = " (" + ac_number_format(paginators[1].total, decimalDelim, commaDelim) + ")";
	$("optinoptout_list_count").className = "ac_inline";
	if ( $('selectXPageAllBox') ) {
		var spans = $('selectXPageAllBox').getElementsByTagName('span');
		if ( spans.length > 2 ) {
			spans[2].innerHTML = ac_number_format(paginators[1].total, decimalDelim, commaDelim);
		}
	}

	$("loadingBar").className = "ac_hidden";
}

// This function should only be run through a paginator (e.g., paginators[n].paginate(offset))
function optinoptout_list_paginate(offset) {
	if (!ac_loader_visible() && !ac_result_visible() && !ac_error_visible())
		ac_ui_api_call(jsLoading);

	if (optinoptout_list_filter > 0)
		$("list_clear").style.display = "inline";
	else
		$("list_clear").style.display = "none";

	optinoptout_list_offset = parseInt(offset, 10);

	ac_ui_anchor_set(optinoptout_list_anchor());
	$("loadingBar").className = "ac_block";
	ac_ajax_call_cb(this.ajaxURL, this.ajaxAction, paginateCB, this.id, optinoptout_list_sort, optinoptout_list_offset, this.limit, optinoptout_list_filter);

	$("list").className = "ac_block";
}

function optinoptout_list_clear() {
	optinoptout_list_sort = "01";
	optinoptout_list_offset = "0";
	optinoptout_list_filter = "0";
	optinoptout_listfilter = null;
	$("JSListManager").value = 0;
	$("list_search").value = "";
	list_filters_update(0, 0, true);
	optinoptout_search_defaults();
	ac_ui_anchor_set(optinoptout_list_anchor());
}

function optinoptout_list_search() {
	var post = ac_form_post($("list"));
	optinoptout_listfilter = post.listid;
	list_filters_update(0, post.listid, false);
	ac_ajax_post_cb("api.php", "optinoptout.optinoptout_filter_post", optinoptout_list_search_cb, post);
}

function optinoptout_list_search_cb(xml) {
	var ary = ac_dom_read_node(xml);

	optinoptout_list_filter = ary.filterid;
	ac_ui_anchor_set(optinoptout_list_anchor());
}

function optinoptout_list_chsort(newSortId) {
	var oldSortId = ( optinoptout_list_sort.match(/D$/) ? optinoptout_list_sort.substr(0, 2) : optinoptout_list_sort );
	var oldSortObj = $('list_sorter' + oldSortId);
	var sortObj = $('list_sorter' + newSortId);
	// if sort column didn't change (only direction [asc|desc] did)
	if ( oldSortId == newSortId ) {
		// switching asc/desc
		if ( optinoptout_list_sort.match(/D$/) ) {
			// was DESC
			newSortId = optinoptout_list_sort.substr(0, 2);
			sortObj.className = 'ac_sort_asc';
		} else {
			// was ASC
			newSortId = optinoptout_list_sort + 'D';
			sortObj.className = 'ac_sort_desc';
		}
	} else {
		// remove old optinoptout_list_sort
		if ( oldSortObj ) oldSortObj.className = 'ac_sort_other';
		// set sort field
		sortObj.className = 'ac_sort_asc';
	}
	optinoptout_list_sort = newSortId;
	ac_ui_api_call(jsSorting);
	ac_ui_anchor_set(optinoptout_list_anchor());
	return false;
}

function optinoptout_list_discern_sortclass() {
	if (optinoptout_list_sort_discerned)
		return;

	var elems = $("list_head").getElementsByTagName("a");

	for (var i = 0; i < elems.length; i++) {
		var str = sprintf("list_sorter%s", optinoptout_list_sort.substring(0, 2));

		if (elems[i].id == str) {
			if (optinoptout_list_sort.match(/D$/))
				elems[i].className = "ac_sort_desc";
			else
				elems[i].className = "ac_sort_asc";
		} else {
			elems[i].className = "ac_sort_other";
		}
	}

	optinoptout_list_sort_discerned = true;
}

{/literal}
