{literal}
var bounce_table = new ACTable();
var bounce_list_sort_discerned = false;

bounce_table.setcol(0, function(row) {
	if ( row.subscriberid > 0 ) {
		return Builder.node('a', { href: 'main.php?action=subscriber_view&id=' + row.subscriberid }, [ Builder._text(row.email) ]);
	} else {
		return Builder.node('span', {}, [ Builder._text(row.email) ]);
	}
});

bounce_table.setcol(1, function(row) {
	return sql2date(row.tstamp).format(datetimeformat);
});

bounce_table.setcol(2, function(row) {
	if (row.code == "9.1.1")
		return "-";
	else
		return row.code;
});

bounce_table.setcol(3, function(row) {
	return row.type;
});

bounce_table.setcol(4, function(row) {
	return row.descript;
});

function bounce_totals() {
	ac_ajax_call_cb("api.php?hash=" + report_campaign_list_hash, "bounce_data.bounce_data_select_totals", ac_ajax_cb(bounce_totals_cb), report_campaign_id, $("messageid").value);
}

function bounce_totals_cb(ary) {
	$("bounce_total_t").innerHTML = ary.totalbounces;
	$("bounce_hard_t").innerHTML  = ary.hardbounces;
	$("bounce_soft_t").innerHTML  = ary.softbounces;
	$("bounce_total_p").innerHTML = sprintf("(%.2f%%)", ary.total_amt > 0 ? 100 * ary.totalbounces / ary.total_amt : 0);
	$("bounce_hard_p").innerHTML  = sprintf("(%.2f%%)", ary.total_amt > 0 ? 100 * ary.hardbounces / ary.total_amt : 0);
	$("bounce_soft_p").innerHTML  = sprintf("(%.2f%%)", ary.total_amt > 0 ? 100 * ary.softbounces / ary.total_amt : 0);
}

function bounce_tabelize(rows, offset) {
	if (rows.length < 1) {
		// We may have some trs left if we just deleted the last row.
		ac_dom_remove_children($("bounce_table"));

		$("bounce_noresults").className = "ac_block";
		$("bounce_loadingBar").className = "ac_hidden";
		ac_ui_api_callback();
		bounce_totals();
		return;
	}
	$("bounce_noresults").className = "ac_hidden";
	window.t_rows = rows;
	ac_paginator_tabelize(bounce_table, "bounce_table", rows, offset);
	$("bounce_loadingBar").className = "ac_hidden";

	bounce_totals();
}

// This function should only be run through a paginator (e.g., paginators[n].paginate(offset))
function bounce_paginate(offset) {
	if (!ac_loader_visible() && !ac_result_visible() && !ac_error_visible())
		ac_ui_api_call(jsLoading);

	if (report_campaign_list_filter > 0)
		$("bounce_clear").style.display = "inline";
	else
		$("bounce_clear").style.display = "none";

	report_campaign_list_offset = parseInt(offset, 10);

	ac_ui_anchor_set(report_campaign_list_anchor());
	$("bounce_loadingBar").className = "ac_block";
	ac_ajax_call_cb(this.ajaxURL, this.ajaxAction, paginateCB, this.id, report_campaign_list_sort, report_campaign_list_offset, this.limit, report_campaign_list_filter, report_campaign_id, $("messageid").value);

	$("bounce").className = "ac_block";
}

function bounce_list_search() {
	var post = ac_form_post($("bounce"));
	report_campaign_list_filter = post.listid;
	list_filters_update(0, post.listid, false);
	ac_ajax_post_cb("api.php", "bounce_data.bounce_data_filter_post", bounce_list_search_cb, post);
}

function bounce_list_search_cb(xml) {
	var ary = ac_dom_read_node(xml);

	report_campaign_list_filter = ary.filterid;
	ac_ui_anchor_set(report_campaign_list_anchor());
}

function bounce_list_chsort(newSortId) {
	var oldSortId = ( report_campaign_list_sort.match(/D$/) ? report_campaign_list_sort.substr(0, 2) : report_campaign_list_sort );
	var oldSortObj = $('bounce_list_sorter' + oldSortId);
	var sortObj = $('bounce_list_sorter' + newSortId);
	// if sort column didn't change (only direction [asc|desc] did)
	if ( oldSortId == newSortId ) {
		// switching asc/desc
		if ( report_campaign_list_sort.match(/D$/) ) {
			// was DESC
			newSortId = report_campaign_list_sort.substr(0, 2);
			sortObj.className = 'ac_sort_asc';
		} else {
			// was ASC
			newSortId = report_campaign_list_sort + 'D';
			sortObj.className = 'ac_sort_desc';
		}
	} else {
		// remove old report_campaign_list_sort
		if ( oldSortObj ) oldSortObj.className = 'ac_sort_other';
		// set sort field
		sortObj.className = 'ac_sort_asc';
	}
	report_campaign_list_sort = newSortId;
	ac_ui_api_call(jsSorting);
	ac_ui_anchor_set(report_campaign_list_anchor());
	return false;
}

function bounce_list_discern_sortclass() {
	if (bounce_list_sort_discerned)
		return;

	var elems = $("list_head").getElementsByTagName("a");

	for (var i = 0; i < elems.length; i++) {
		var str = sprintf("bounce_list_sorter%s", report_campaign_list_sort.substring(0, 2));

		if (elems[i].id == str) {
			if (report_campaign_list_sort.match(/D$/))
				elems[i].className = "ac_sort_desc";
			else
				elems[i].className = "ac_sort_asc";
		} else {
			elems[i].className = "ac_sort_other";
		}
	}

	bounce_list_sort_discerned = true;
}

function bounce_list_clear() {
	report_campaign_list_sort = "01";
	report_campaign_list_offset = "0";
	report_campaign_list_filter = "0";
	$("bounce_search").value = "";
	ac_ui_anchor_set(report_campaign_list_anchor());
}
{/literal}
