var template_table = new ACTable();
var template_list_sort = "01";
var template_list_offset = "0";
var template_list_filter = {jsvar var=$filterid};
var template_list_sort_discerned = false;

var template_list_str_exportas = '{"Export As:"|alang|js}';
var template_txt_global = '{"Global"|alang}';

{literal}
template_table.setcol(0, function(row) {
	return Builder.node("input", { type: "checkbox", name: "multi[]", value: row.id, onclick: "ac_form_check_selection_none(this, $('acSelectAllCheckbox'), $('selectXPageAllBox'))" });
});

template_table.setcol(1, function(row) {
	var edit = Builder.node("a", { href: sprintf("#form-%d", row.id) }, jsOptionEdit);
	var dele = Builder.node("a", { href: sprintf("#delete-%d", row.id) }, jsOptionDelete);
	var exprt = Builder.node("a", { href: "#", onclick: sprintf("return template_list_export(%d);", row.id) }, jsOptionExport);

	var ary = [];
	var nodes = [ ];

	if (ac_js_admin.pg_template_edit) {
		ary.push(edit);
		ary.push(" ");
	}

	ary.push(exprt);
	ary.push(" ");

	if (ac_js_admin.pg_template_delete) {
		ary.push(dele);
	}

	nodes.push(Builder._text(template_list_str_exportas));
	nodes.push(Builder.node('br'));
	nodes.push(Builder.node('a', { href: "export.php?action=template&type=xml&id=" + row.id }, [ Builder._text(strImportTypeXML) ] ));
	nodes.push(" · ");
	nodes.push(Builder.node('a', { href: "export.php?action=template&type=html&id=" + row.id }, [ Builder._text(strImportTypeHTML) ] ));
	ary.push(Builder.node('div', { id: 'template_export' + row.id, className: 'ac_hidden' }, nodes ));

	return Builder.node("div", { className: "ac_table_row_options" }, ary);
});

template_table.setcol(2, function(row) {
	// name
	return row.name;
});

template_table.setcol(3, function(row) {
	// format
	return Builder._text(row.format.toUpperCase());
});

template_table.setcol(4, function(row) {
	// lists
	return (row.is_global) ? Builder.node('em', { style: 'font-style: italic;' }, template_txt_global) : row.lists;
});

function template_list_anchor() {
	return sprintf("list-%s-%s-%s", template_list_sort, template_list_offset, template_list_filter);
}

function template_list_tabelize(rows, offset) {
	if (rows.length < 1) {
		/*
		if (!template_list_filter || template_list_filter == 0) {
			ac_ui_api_callback();
			ac_ui_anchor_set('form-0');
			return;
		}
		*/
		// We may have some trs left if we just deleted the last row.
		ac_dom_remove_children($("list_table"));

		$("list_noresults").className = "ac_block";
		if ($("list_delete_button") !== null)
			$("list_delete_button").className = "ac_hidden";
		$("loadingBar").className = "ac_hidden";
		ac_ui_api_callback();
		return;
	}
	$("list_noresults").className = "ac_hidden";
	if ($("list_delete_button") !== null)
		$("list_delete_button").className = "ac_inline";
	ac_paginator_tabelize(template_table, "list_table", rows, offset);

	$("template_list_count").innerHTML = " (" + ac_number_format(paginators[1].total, decimalDelim, commaDelim) + ")";
	$("template_list_count").className = "ac_inline";

	$("loadingBar").className = "ac_hidden";
}

// This function should only be run through a paginator (e.g., paginators[n].paginate(offset))
function template_list_paginate(offset) {
	if (!ac_loader_visible() && !ac_result_visible() && !ac_error_visible())
		ac_ui_api_call(jsLoading);

	if (template_list_filter > 0)
		$("list_clear").style.display = "inline";
	else
		$("list_clear").style.display = "none";

	template_list_offset = parseInt(offset, 10);

	ac_ui_anchor_set(template_list_anchor());
	$("loadingBar").className = "ac_block";
	ac_ajax_call_cb(this.ajaxURL, this.ajaxAction, paginateCB, this.id, template_list_sort, template_list_offset, this.limit, template_list_filter);

	$("list").className = "ac_block";
}

function template_list_clear() {
	template_list_sort = "01";
	template_list_offset = "0";
	template_list_filter = "0";
	template_listfilter = null;
	$("JSListManager").value = 0;
	$("list_search").value = "";
	list_filters_update(0, 0, true);
	template_search_defaults();
	ac_ui_anchor_set(template_list_anchor());
}

function template_list_search() {
	var post = ac_form_post($("list"));
	template_listfilter = post.listid;
	list_filters_update(0, post.listid, false);
	ac_ajax_post_cb("api.php", "template.template_filter_post", template_list_search_cb, post);
}

function template_list_search_cb(xml) {
	var ary = ac_dom_read_node(xml);

	template_list_filter = ary.filterid;
	ac_ui_anchor_set(template_list_anchor());
}

function template_list_chsort(newSortId) {
	var oldSortId = ( template_list_sort.match(/D$/) ? template_list_sort.substr(0, 2) : template_list_sort );
	var oldSortObj = $('list_sorter' + oldSortId);
	var sortObj = $('list_sorter' + newSortId);
	// if sort column didn't change (only direction [asc|desc] did)
	if ( oldSortId == newSortId ) {
		// switching asc/desc
		if ( template_list_sort.match(/D$/) ) {
			// was DESC
			newSortId = template_list_sort.substr(0, 2);
			sortObj.className = 'ac_sort_asc';
		} else {
			// was ASC
			newSortId = template_list_sort + 'D';
			sortObj.className = 'ac_sort_desc';
		}
	} else {
		// remove old template_list_sort
		if ( oldSortObj ) oldSortObj.className = 'ac_sort_other';
		// set sort field
		sortObj.className = 'ac_sort_asc';
	}
	template_list_sort = newSortId;
	ac_ui_api_call(jsSorting);
	ac_ui_anchor_set(template_list_anchor());
	return false;
}

function template_list_discern_sortclass() {
	if (template_list_sort_discerned)
		return;

	var elems = $("list_head").getElementsByTagName("a");

	for (var i = 0; i < elems.length; i++) {
		var str = sprintf("list_sorter%s", template_list_sort.substring(0, 2));

		if (elems[i].id == str) {
			if (template_list_sort.match(/D$/))
				elems[i].className = "ac_sort_desc";
			else
				elems[i].className = "ac_sort_asc";
		} else {
			elems[i].className = "ac_sort_other";
		}
	}

	template_list_sort_discerned = true;
}


function template_list_export(id) {
	ac_dom_toggle_class('template_export' + id, 'ac_offer', 'ac_hidden');
	return false;
}

{/literal}
