#!/usr/local/bin/php
<?php

// require main include file
require_once(dirname(__FILE__) . '/prepend.inc.php');
require_once(ac_global_functions('process.php'));
require_once ac_global_functions("cron.php");

ac_flush('');

// turning off some php limits
@ignore_user_abort(1);
@ini_set('max_execution_time', 950 * 60);
@set_time_limit(950 * 60);
$ml = ini_get('memory_limit');
if ( $ml != -1 and (int)$ml < 128 and substr($ml, -1) == 'M') @ini_set('memory_limit', '128M');
set_include_path('.');

// admin permission reset (use admin=1!)
$admin = ac_admin_get_totally_unsafe(1);

// Preload the language file
ac_lang_get('admin');

$id = (int)ac_http_param('id');
$debug = (bool)ac_http_param('debug');



if ( $id == 0 ) {
	$id = ( isset($_SERVER['argv'][1]) ? (int)$_SERVER['argv'][1] : 0 );
	if ( isset($_SERVER['argv'][2]) ) $debug = (bool)$_SERVER['argv'][2];
}

if ( $debug ) $_GET['debugspawn'] = 1;

if ( $id == 0 ) {
	ac_flush('');

	ac_cron_monitor_start(basename(__FILE__, '.php')); // log cron start
	ac_process_respawn(null, $debug); // this triggers to run all process
	ac_cron_monitor_stop(); // log cron end
} else {
	ac_flush('.');
	ac_process_pickup($id); // this runs process
}

ac_process_cleanup(); // this removes old&finished processes

?>
