<?php

require_once ac_admin("functions/form.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
class form_context extends ACP_Page {

	function form_context() {
		$this->pageTitle = _a("Subscription Form");
		$this->ACP_Page();
	}

	function process(&$smarty) {

		$this->setTemplateData($smarty);

		// get form id
		$id = (int)ac_http_param('id');
		if ( $id == 0 ) {
			ac_http_redirect(ac_site_plink());
		}

		// get form object
		$form = form_select_row($id);
		if ( $id == 0 ) {
			ac_http_redirect(ac_site_plink());
		}

		// get code type
		$type = (string)ac_http_param('type');

		// get source character set
		$_charset = (string)ac_http_param('_charset');
		if ( !$_charset ) $_charset = _i18n('utf-8');

		// generate the actual subscription form
		$this->site['acpow'] = base64_encode($this->site['acpow']);
		$code = form_generate($form, $type);
		$this->site['acpow'] = base64_decode($this->site['acpow']);

		if ( $_charset != _i18n('utf-8') ) {
			$code = str_replace(
				'<input type="hidden" name="_charset" value="' . _i18n('utf-8') . '" />',
				'<input type="hidden" name="_charset" value="' . $_charset . '" />',
				$code
			);
		}

		// print it out and stop if only form is requested
		if ( in_array($type, array('html', 'xml', 'link', 'popup')) ) {
			echo $code;
			exit;
		}

		$smarty->assign('form', $form);
		$smarty->assign('code', $code);

		// display regular page with form inside
		$smarty->assign("content_template", "form.htm");
	}
}

?>
